/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


//CBlackBoardServer.h
#ifndef __BLACKBOARDSERVER__
#define __BLACKBOARDSERVER__

#include "ver.h"

#include <e32base.h>
#include <app_context.h>
#include <bbdata.h>
#include "blackboard_cs.h"
#include <d32dbms.h>
#include "tuplestore.h"
#include "subscriptions.h"
#include <symbian_tree.h>

class MBlackBoardObserver {
public:
	virtual void NotifyL(TUint aId, TBBPriority aPriority,
			TTupleType aTupleType,
			const TTupleName& aTupleName, const TDesC& aSubName, 
			const TComponentName& aComponent,
			const TDesC8& aSerializedData) = 0;
	virtual void NotifyL(TUint aId, TBBPriority aPriority) = 0;
};

class CBlackBoardServer : public CServer, public MContextBase
{
public:

	static CBlackBoardServer* NewL(MApp_context& Context, TBool aRunAsServer=ETrue);
	~CBlackBoardServer();

	static TInt ThreadFunction(TAny* aNone);
	
	void IncrementSessions();
	void DecrementSessions();

private:
	void RunL();
	TInt CheckedRunError(TInt aError);

	CBlackBoardServer(TInt aPriority, MApp_context& Context) ;

	void ConstructL(TBool aRunAsServer);

	static void PanicClient(const RMessage& aMessage, TBlackBoardServPanic aReason);
	static void PanicServer(TBlackBoardServPanic aReason);
	static void ThreadFunctionL();

	//-------------------------------------------------------------
	// communications ...
	//-------------------------------------------------------------
	
public:
	void GetL(TTupleName& aName, TDes& aSubName, TUint& aIdInto, TTupleType& aTupleTypeInto,
		TComponentName& aComponentInto,
		RADbColReadStream& aDataInto, TUint& aSizeInto);

	void GetL(TComponentName& aComponent, TUint& aIdInto, TTupleType& aTupleTypeInto,
		TTupleName& aNameInto, TDes& aSubNameInto,
		RADbColReadStream& aDataInto, TUint& aSizeInto);

	void GetL(TUint aId, TTupleType& aTupleTypeInto,
		TTupleName& aName, TDes& aSubName,
		TComponentName& aComponentInto,
		RADbColReadStream& aDataInto, TUint& aSizeInto);


	// this Leave's if storing the tuple fails and returns
	// an error code if notification fails for some
	TInt PutL(const TTupleName& aTupleName, const TDesC& aSubName, const TComponentName& aComponent,
		 const TDesC8& aSerializedData, TBBPriority aPriority, TBool aReplace, TUint& aIdInto,
		 TBool aPersist=ETrue, TTupleType aTupleType=ETupleDataOrRequest);
	void DeleteL(const TTupleName& aName, const TDesC& aSubName);
	void DeleteL(TUint aId);

	TInt AddNotificationL(MBlackBoardObserver *aSession, const TTupleName& aTupleName, 
		TBool aGetExisting, TBBPriority aPriority);
	void DeleteNotificationL(MBlackBoardObserver *aSession, const TTupleName& aTupleName);
	TInt AddNotificationL(MBlackBoardObserver *aSession, const TComponentName& aComponentName, 
		TBool aGetExisting, TBBPriority aPriority);
	void DeleteNotificationL(MBlackBoardObserver *aSession, 
		const TComponentName& aComponentName);

	void DeleteAllNotificationsL(MBlackBoardObserver *aSession);
	void DeleteAllNotificationsL();

	void TerminateServer();
private:
	// these continue on errors but return the last error
	void NotifyTupleL(TUint aId, 
			const TTupleName& aTupleName, const TDesC& aSubName, 
			const TComponentName& aComponent,
			const TDesC8& aSerializedData);
	void NotifyComponentL(TUint aId, TBBPriority aPriority,
			TTupleType aTupleType,
			const TTupleName& aTupleName, const TDesC& aSubName, 
			const TComponentName& aComponent,
			const TDesC8& aSerializedData);
	void NotifyExistingL(MBlackBoardObserver *aSession, 
		const TTupleName& aTupleName, TBBPriority aPriority);
	void NotifyExistingL(MBlackBoardObserver *aSession, 
		const TComponentName& aComponentName, TBBPriority aPriority);

	TInt iSessionCount;
	CSharableSession *	NewSessionL(const TVersion &aVersion) const;

	CDb		*iDb;
	CTupleStore	*iTupleStore;
	CSubscriptions	*iSubscriptions;
	CGenericIntMap	*iSubDuplicate;

	class CPermanentSubscriptions* iPermanent;
};

#endif
