/*
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


//CBlackBoardServerSession.h
#ifndef __CBLACKBOARDSERVERSESSION__
#define __CBLACKBOARDSERVERSESSION__

#include <e32base.h>
#include "BlackBoardServer.h"
#include "blackboard_cs.h"
#include <list.h>

class CIdleCallBack;
class MBack { public: virtual void Back() = 0; };

class CBlackBoardServerSession : public CSession, public MBlackBoardObserver, public MBack
{

public: 
	static CBlackBoardServerSession* NewL(RThread& aClient, CBlackBoardServer& aServer);
	static CBlackBoardServerSession* NewLC(RThread& aClient, CBlackBoardServer& aServer);
	~CBlackBoardServerSession();
	
	void ServiceL(const RMessage& aMessage);

private:
	CBlackBoardServerSession(RThread& aClient, CBlackBoardServer& aServer);
	void ConstructL() ;
	void PanicClient(TInt aPanic) const;

	virtual void NotifyDirectL(TUint aId, TBBPriority aPriority,
			TTupleType aTupleType,
			const TTupleName& aTupleName, const TDesC& aSubName, 
			const TComponentName& aComponent,
			const TDesC8& aSerializedData);
	virtual void NotifyL(TUint aId, TBBPriority aPriority,
			TTupleType aTupleType,
			const TTupleName& aTupleName, const TDesC& aSubName, 
			const TComponentName& aComponent,
			const TDesC8& aSerializedData);
	virtual void NotifyL(TUint aId, TBBPriority aPriority);
	virtual void Back();
private: 
	enum TMessageIdxs {
		ENotifyMsgIndex,
		EOtherMsgIndex
	};

	void GetByTupleL();
	void GetByComponentL();
	void PutL();
	void DeleteByTupleL();
	void DeleteByIdL();
	void AddTupleFilterL();
	void DeleteTupleFilterL();
	void AddComponentFilterL();
	void DeleteComponentFilterL();
	TBool SendWaitingL();
	void TerminateServer();

	void ReadTupleAndSubL(TMessageIdxs aWhich);
	void ReadComponentL(TMessageIdxs aWhich);
	void ReadId(TMessageIdxs aWhich);
	TUint iSize;
	TUint iFlags;
	void ReadFlags(TMessageIdxs aWhich);
	TFullArgs iFullArgs;
	void ReadFullArgsL(TMessageIdxs aWhich);
	void ReadPriorityL(TMessageIdxs aWhich);
	void ReadTupleL(TMessageIdxs aWhich);

	HBufC8* ReadDataL(TMessageIdxs aWhich);

	
	RMessage		iMessage[2]; TInt iMessageThreadId[2];
	void CompleteMessage(TMessageIdxs aWhich, TInt Code);
	void WriteDataL(RADbColReadStream& rs, TMessageIdxs aIdx);
	void WriteDataL(const TDesC8& data, TMessageIdxs aIdx);

	void SetMessage(TMessageIdxs aWhich, const RMessage& aMsg);
	CBlackBoardServer&     iServer;

	void			AppendNotificationL(TUint aId);
	TUint			TopNotification();
	TUint			PopNotification();
	//CList<TUint>*		iNotifications[KPriorityCount];
	CArrayFixSeg<TUint>	*iNotifications;
	CIdleCallBack*		iIdle;
	TBool			iWaitingForNotify;
	TBool			iInPut; // ignore notifications for puts on this session, if so requested
};

#endif
