#ifndef BB_TUPLESTORE_H_INCLUDED
#define BB_TUPLESTORE_H_INCLUDED 1

#include <db.h>
#include <bbdata.h>
#include "blackboard_cs.h"
#include <raii_d32dbms.h>

class CTupleStore : public CBase
{
public:
	static CTupleStore* NewL(RDbDatabase& Db, MApp_context& Context);

	virtual void GetCurrentL(TTupleName& aNameInto, TDes& aSubNameInto, 
		TUint& aIdInto, TTupleType& aTupleTypeInto, TComponentName& aComponentInto, 
		RADbColReadStream& aDataInto, TUint& aSizeInto) = 0;
	virtual TUint PutL(TTupleType aTupleType, const TTupleName& aTupleName, 
		const TDesC& aSubName, const TComponentName& aComponent,
		const TDesC8& aSerializedData, TBBPriority aPriority, TBool aReplace) = 0;
	virtual void DeleteL(TTupleType aTupleType, const TTupleName& aName, const TDesC& aSubName) = 0;
	virtual void DeleteL(TUint aId, TTupleType& aTupleTypeInto, TTupleName& aNameInto, TDes& aSubNameInto) = 0;

	virtual void SeekL(TUint aId) = 0;
	virtual TBool FirstL(TTupleType aTupleType, const TTupleName& aTupleName, const TDesC& aSubName, 
		TBool aExact=EFalse) = 0;
	virtual TBool FirstL(TTupleType aTupleType, const TComponentName& aComponentName) = 0;
	virtual TBool NextL() = 0;
	virtual TUint GetCurrentIdL() = 0;

	~CTupleStore();
};

#endif
