/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


//BlackBoardServer Main.cpp

#include "BlackBoardServer.h"

#ifdef __WINS__
// @anchor WinsMain
IMPORT_C TInt WinsMain();
EXPORT_C TInt WinsMain()
{
	CALLSTACKITEM_N(_CL("HBufC8"), _CL("NewL"));

	return reinterpret_cast<TInt>(&CBlackBoardServer::ThreadFunction);
}

// @anchor E32Dll
GLDEF_C TInt E32Dll(TDllReason)
{
	CALLSTACKITEM_N(_CL("CBlackBoardServer"), _CL("ThreadFunction"));

	return KErrNone;
}

#else  // __ARMI__

// @anchor E32Main
TInt E32Main()
{
	CALLSTACKITEM_N(_CL("CBlackBoardServer"), _CL("ThreadFunction"));

	return CBlackBoardServer::ThreadFunction(NULL);
}

#endif
