#include "permanent.h"
#include "list.h"
#include "concretedata.h"
#include "bb_incoming.h"
#include "bbxml.h"
#include "raii_f32file.h"
#include "bbtypes.h"

class CPermanentProxy : public CBase, public MBlackBoardObserver {
public:
	static CPermanentProxy* NewL(CBlackBoardServer* aServer, TComponentName& aComponentName)
	{
		auto_ptr<CPermanentProxy> ret(new (ELeave) CPermanentProxy(aServer, aComponentName));
		return ret.release();
	}
	~CPermanentProxy() {
		iServer->DeleteAllNotificationsL(this);
	}
private:
	CPermanentProxy(CBlackBoardServer* aServer, TComponentName& aComponentName) : 
		iComponentName(aComponentName), iServer(aServer) { }
	virtual void NotifyL(TUint /*aId*/, TBBPriority aPriority,
			TTupleType /*aTupleType*/,
			const TTupleName& aTupleName, const TDesC& aSubName, 
			const TComponentName& /*aComponent*/,
			const TDesC8& aSerializedData) {

		TUint dummy;
		iServer->PutL(aTupleName, aSubName, iComponentName,
			aSerializedData, aPriority, EFalse,
			dummy, ETrue, ETuplePermanentSubscriptionEvent);
	}

	virtual void NotifyL(TUint aId, TBBPriority aPriority) {
		TFullArgs args;
		TUint size, dummy;
		RADbColReadStream rs;
		iServer->GetL(aId, args.iTupleType, args.iTupleName, args.iSubName, 
			args.iComponentName, rs, size);
		auto_ptr< HBufC8 > buf(HBufC8::NewL(size));
		TPtr8 p(buf->Des());
		if (size>0) {
			rs.ReadL(p, size);
		}
		iServer->PutL(args.iTupleName, args.iSubName, iComponentName,
			*buf, aPriority, EFalse,
			dummy, ETrue, ETupleRequest);
	}

	CBlackBoardServer* iServer;
	TComponentName iComponentName;
};

class CPermanentSubscriptionsImpl : public CPermanentSubscriptions, public MContextBase,
	public MBBStream, public MIncomingObserver {
private:
	CPermanentSubscriptionsImpl(MApp_context& aContext, CBlackBoardServer* aServer);
	~CPermanentSubscriptionsImpl();
	void ConstructL();
	void ReadSubscriptionsL();
	void HandleFileL(const TDesC& aFileName);

	// MBBStream
	const MBBData* Part(TUint aPartNo) const;
        virtual const TTypeName& Type() const;
	virtual void ResetPart(TUint aPart);

	// MBBIncomingObserver
	virtual void StreamOpened() { }
	virtual void StreamClosed() { }
	virtual void IncomingData(const MBBData* aData, TBool aErrors);
	virtual void StreamError(TInt aError, const TDesC& aDescr);

	TBBComponentName	iComponent;
	TBBTupleName		iTuple;

	CPtrList<CPermanentProxy> *iProxies;
	CPermanentProxy*	iCurrentProxy;
	CBlackBoardServer* iServer;

	friend class CPermanentSubscriptions;
	friend class auto_ptr<CPermanentSubscriptionsImpl>;
};

CPermanentSubscriptions* CPermanentSubscriptions::NewL(MApp_context& Context, CBlackBoardServer* aServer)
{
	auto_ptr<CPermanentSubscriptionsImpl> ret(new (ELeave) CPermanentSubscriptionsImpl(Context, aServer));
	ret->ConstructL();
	return ret.release();
}

_LIT(KComponent, "component");
_LIT(KTuple, "tuplename");
_LIT(KSubscriptions, "subscriptions");

CPermanentSubscriptionsImpl::CPermanentSubscriptionsImpl(MApp_context& aContext, 
							CBlackBoardServer* aServer) : 
	MContextBase(aContext), MBBStream(KSubscriptions, *this),
	iComponent(KComponent), iTuple(KTuple), iServer(aServer)
{
}

void CPermanentSubscriptionsImpl::ConstructL()
{
	MBBStream::ConstructL();
	iProxies=CPtrList<CPermanentProxy>::NewL();
}

CPermanentSubscriptionsImpl::~CPermanentSubscriptionsImpl()
{
	delete iProxies;
}

void CPermanentSubscriptionsImpl::ReadSubscriptionsL()
{
	TFileName dirname=_L("e:"), filename;
	dirname.Append(KSubscriptionDir);
	dirname.Append(_L("*.xml"));
	for (int i=0; i<2; i++) {
		CDir* dir=0;
		TInt err=Fs().GetDir(dirname, KEntryAttMaskSupported, 
			ESortByName, dir);
		if (err!=KErrNone) {
			dirname.Replace(0, 1, _L("c"));
			continue;
		}
		auto_ptr<CDir> auto_dir(dir);
		for (int f=0; f<dir->Count(); f++) {
			filename=dirname.Left(dirname.Length()-5);
			filename.Append( (*dir)[f].iName );
			TRAPD(err, HandleFileL( filename ));
			if (err!=KErrNone) {
				//TODO: log
			}
		}
		dirname.Replace(0, 1, _L("c"));
	}
}

void CPermanentSubscriptionsImpl::HandleFileL(const TDesC& aFileName)
{
	RAFile file; file.OpenLA(Fs(), aFileName, EFileRead|EFileShareAny);
	MBBStream::Reset();
	TBuf8<256> buf;
	while (file.Read(buf)==KErrNone && buf.Length()) {
		ParseL(buf);
		buf.Zero();
	}
}

// MBBStream
const MBBData* CPermanentSubscriptionsImpl::Part(TUint aPartNo) const
{
	switch(aPartNo) {
	case 0:
		return &iComponent;
	case 1:
		return &iTuple;
	default:
		return 0;
	}
}

const TTypeName& CPermanentSubscriptionsImpl::Type() const
{
	return KNoType;
}

void CPermanentSubscriptionsImpl::ResetPart(TUint aPart)
{
	switch(aPart) {
	case 0:
		iComponent=KNoComponent;
	case 1:
		iTuple=KNoTuple;
	}
}


void CPermanentSubscriptionsImpl::IncomingData(const MBBData* aData, TBool aErrors)
{
	if (aErrors) {
		// TODO: log
		if (aData==&iComponent) iCurrentProxy=0;
		return;
	}
	if (aData==&iComponent) {
		TComponentName n;
		n.iModule.iUid=iComponent.iModuleUid();
		n.iId=iComponent.iModuleId();
		auto_ptr<CPermanentProxy> p(CPermanentProxy::NewL(iServer, n));
		iCurrentProxy=p.get();
		iProxies->AppendL(p.get());
		p.release();
	} else {
		if (iCurrentProxy) {
			TTupleName n;
			n.iModule.iUid=iTuple.iModuleUid();
			n.iId=iTuple.iModuleId();
			iServer->AddNotificationL(iCurrentProxy, n, EFalse, EBBPriorityNormal);
		} else {
			// TODO: log
		}
	}
}

void CPermanentSubscriptionsImpl::StreamError(TInt aError, const TDesC& aDescr)
{
	// TODO: log
}
