#ifndef CONTEXTCALLLOGAPPUI_H
#define CONTEXTCALLLOGAPPUI_H

#include <eikapp.h>
#include <eikdoc.h>
#include <e32std.h>
#include <coeccntx.h>
#include <aknviewappui.h>
#include <akntabgrp.h>
#include <aknnavide.h>
#include <akniconarray.h>
#include "app_context.h"
#include "file_output_base.h"
#include "presencedetailview.h"
#include "call_log.h"
#include "phonehelper.h"
#include "cb_presence.h"
#include "contextcalllogview.h"


class CContextCallLogContainer;

class CContextCallLogAppUi : public CAknViewAppUi, public MContextBase, MCoeForegroundObserver, public MPresenceListener, public MTimeOut
{
public: 
	CContextCallLogAppUi(MApp_context& Context) : MContextBase(Context) { }
        void ConstructL();
        ~CContextCallLogAppUi();

public: // New functions
	void Notify(const TDesC& aMessage);
	void PresenceChangedL(TInt ContactId, CBBPresence* Info);
	void DisplayPresenceDetailsL(const TDesC& Name, const CBBPresence* PresenceData);
public:
	void SetTab(TInt tabId);
        
private:
	virtual void HandleGainingForeground();
	virtual void HandleLosingForeground();
    
private:
        void HandleCommandL(TInt aCommand);
	virtual void ProcessMessageL(TUid aUid,const TDesC8& aParams);
	void HandleWsEventL(const TWsEvent& aEvent,CCoeControl* aDestination);
	void hide();
	virtual TKeyResponse HandleKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);
	
private:

	typedef void (CContextCallLogAppUi::*TCallBack)(void);
	CList<TCallBack> *iWaitingOps;
	CTimeOut	 *iWait;
	void QueueOp(TCallBack Op, int AfterSeconds=0);
	void expired(CBase*);


        CAknNavigationControlContainer* iNaviPane;
        CAknNavigationDecorator*        iDecoratedTabGroup;
	CAknTabGroup*                   iTabGroup;

	CPresenceDetailView	*iPresenceDetailView; // OWNED BY FRAMEWORK
	CContextCallLogView *iDialledView, *iReceivedView, *iMissedView;

	Cfile_output_base * iLog;

	CAknIconArray * iIconlist;
	CArrayFixFlat<TInt>* iResource_files;

	call_log*	iCallLog;
	phonehelper *   iPhoneHelper;
	CDb*		iJabberDb;
	CJabberData*	iJabberData;

	CPresenceUpdater* iPresenceUpdater;
	CPresenceHolder* iPresenceHolder;
};

#endif

