#ifndef CONTEXTCALLLOGCONTAINER_H
#define CONTEXTCALLLOGCONTAINER_H

#include <coecntrl.h>
#include "contextcalllogview.h"
#include <AknView.h>
#include "phonebook.h"
#include "file_output_base.h"
#include <akniconarray.h>
#include "icons.h"
#include "call_log.h"
#include "doublelinebox.h"

class CContextCallLogContainer : public CCoeControl, MCoeControlObserver, public MEikListBoxObserver, public phonebook_observer,  public MContextBase
{
    public: 
        void ConstructL(const TRect& aRect, call_log* callLog, Cfile_output_base * log, CAknIconArray * aIconlist, CAknView * view, HBufC * title, HBufC * listboxLabel);
        ~CContextCallLogContainer();

public:
	TInt get_current_idx();
	void show_presence_details_current();
	void show_call_details_current();
	void exiting();

   private: 
        void SizeChanged();

        TInt CountComponentControls() const;
        CCoeControl* ComponentControl(TInt aIndex) const;
        void Draw(const TRect& aRect) const;
        void HandleControlEventL(CCoeControl* aControl,TCoeEvent aEventType);
	void HandleListBoxEventL(CEikListBox* aListBox,TListBoxEvent aEventType);

	TKeyResponse OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType);

	void before_change();
	void contents_changed();

	void handle_visibility();
	
  private: 
	  call_log* iCallLog;
	  Cfile_output_base * aLog;
	  CAknView * aView;
	  CAknIconArray * iIconlist;
	  doublelinebox* iListbox;
	  class CPresenceArray *iListBoxArray;
	  class CNameArray* iNameArray;
	  CEikLabel * iEmptyListboxLabel;
};

#endif

