#ifndef CONTEXTCALLLOGVIEW_H
#define CONTEXTCALLLOGVIEW_H

#include <aknview.h>
#include "call_log.h"
#include "phonehelper.h"
#include "jabberdata.h"
#include "file_output_base.h"
#include <akniconarray.h> 
#include <eikmenup.h>


const TUid KMissedViewId = {6};
const TUid KReceivedViewId = {7};
const TUid KDialledViewId = {8};
class CContextCallLogContainer;

class CContextCallLogView : public CAknView, public MContextBase
{
public: 
	CContextCallLogView(CJabberData* jabberData, Cfile_output_base * log, call_log* callLog, 
		CAknIconArray * iconlist, phonehelper& phoneHelper) : aCallLog(callLog), aJabberData(jabberData), 
		aLog(log), aIconlist(iconlist), aPhoneHelper(phoneHelper), mailbox_defined(EFalse) { }
        void ConstructL(TUid viewId);
	~CContextCallLogView();

public: 
	TUid Id() const;
	void HandleCommandL(TInt aCommand);
	void HandleClientRectChange();
	void DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane);

	void exiting();
private:
	void DoActivateL(const TVwsViewId& aPrevViewId,TUid aCustomMessageId,
		const TDesC8& aCustomMessage);
	void DoDeactivate();

private: 
	CContextCallLogContainer* iContainer;
	TUid iViewId;
	call_log * aCallLog;
	CJabberData* aJabberData;
	Cfile_output_base * aLog;
	CAknIconArray * aIconlist;
	CSendAppUi * iSendAppUi;
	phonehelper& aPhoneHelper;
	TBool mailbox_defined;

	HBufC * iTitle;
	HBufC * iEmptyListboxLabel;
};

#endif


