/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CB_CALL_LOG_H_INCLUDED
#define CB_CALL_LOG_H_INCLUDED

#include "phonebook.h"
#include <logview.h>
#include <logcli.h>
#include <symbian_tree.h>
#include <list.h>


class call_log: public phonebook_i, public CCheckedActive, public MContextBase,
	public MPresenceListener {
public:
	call_log(MApp_context& Context, CJabberData * JabberData, CPresenceHolder * PresenceHolder);
	virtual ~call_log();
	void ConstructL();

	void DeleteEvent(TInt index);
	void ClearEventList();
	
	bool filter(const TDesC& substr, bool force=false);
	TPtrC get_phone_no(TInt index);
	virtual void AddObserverL(phonebook_observer* i_obs);
	virtual void RemoveObserverL(phonebook_observer* i_obs);

	virtual CPbkContactEngine* get_engine() { return eng; }

	virtual TInt GetContactId(TInt Index); //{ return KErrNotFound; }
	virtual TInt GetIndex(TInt /*ContactId*/) { return KErrNotFound; }
	virtual contact * GetContact(TInt contactId);// { return NULL; }
	
	void CheckedRunL();
	void DoCancel();

	void refresh();

	void SetMissedFilter();
	void SetReceivedFilter();
	void SetDialledFilter();
	virtual TInt Count();

	virtual void PresenceChangedL(TInt ContactId, CBBPresence* Info);
	void Notify(const TDesC& aMessage);
	
	virtual TBuf<100> ExportVCardToFile(TInt /*ContactId*/) { return _L("");}
	void reset_call_log();

	CLogEvent *  get_event(TInt index);

private:
	bool handle_event(const CLogEvent& ev);
	void copy_new_to_current();
	void ReRead();
	void NotifyContentsChanged();
	virtual void set_observer(phonebook_observer* ) { User::Leave(-1028); }

private:	
	enum state { IDLE, WAITING_SET, WAITING_NEXT, WAITING_DELETE, WAITING_CLEAR, WAITING_CHANGE };
	state current_state;

	CArrayFixFlat<contact*>* current_contacts;
	CArrayFixFlat<contact*>* all_contacts;
	CArrayFixFlat<CLogEvent*> * current_events;
	CArrayFixFlat<CLogEvent*> * all_events;

	CPtrCArray* current_nos;
	CDesCArray* all_nos;
	
	TInt new_from;

	CPbkContactEngine *eng;
	bool owns_engine;
	CList<phonebook_observer*> *iObservers;

	CLogViewRecent* recent;
	CLogClient* logclient;
	CLogFilter* logfilter;

	TLogId last_seen_id;
	bool getting_first;
	
	bool do_refresh; // redo refresh after current

	CJabberData*	iJabberData;
	CPresenceHolder* iPresenceHolder;
        TInt event_count;
};

#endif
