#include "ContextCallLogContainer.h"
#include <contextcalllog.rsg>
#include <akntitle.h> 
#include <s32strm.h>
#include <gulicon.h>
#include "contextcalllog.hrh"
#include <aknmessagequerydialog.h>
#include <logwrap.h>
#include <eikmenub.h>

#include "contextcalllogappui.h"
#include "presence_ui_helper.h"

enum KEYCODES {
	JOY_LEFT = 0xF807,
	JOY_RIGHT = 0xF808,
	JOY_UP = 0xF809,
	JOY_DOWN = 0xF80A,
	JOY_CLICK = 0xF845,
	KEY_CALL = 0xF862,
	KEY_CANCEL = 0xF863,
	KEY_C = 0x0008
};

enum SCANCODES {
	CALL_SCAN = 0xC4,
	CANCEL_SCAN = 0xC5
};


void CContextCallLogContainer::ConstructL(const TRect& aRect, call_log* callLog, Cfile_output_base * log, CAknIconArray * aIconlist, CAknView * view, HBufC * title, HBufC * listboxLabel)
{
	CALLSTACKITEM_N(_CL("CContextCallLogContainer"), _CL("ConstructL"));

	aLog = log;
	aView = view;
	iCallLog = callLog;
	iCallLog->AddObserverL(this);

	CreateWindowL();

        CEikStatusPane* sp=iEikonEnv->AppUiFactory()->StatusPane();
	CAknTitlePane* tp=(CAknTitlePane*)sp->ControlL(TUid::Uid(EEikStatusPaneUidTitle));
	HBufC * t = HBufC::NewL(title->Length());
	*t = *title;
        tp->SetText(t);

	iEmptyListboxLabel = new (ELeave) CEikLabel;
	iEmptyListboxLabel->SetTextL(*listboxLabel);

	TSize size = iEmptyListboxLabel->MinimumSize();
	
	iEmptyListboxLabel->SetPosition( TPoint( (176-size.iWidth)/2, 60) );
	iEmptyListboxLabel->SetSize(TSize(0,0));
	
	iIconlist = new (ELeave) CAknIconArray(30);
	for (TInt i = 0; i< aIconlist->Count();i++)
	{
		CGulIcon * ic, *icon_from; 
		icon_from= (*aIconlist)[i];
		ic=CGulIcon::NewL( icon_from->Bitmap(), icon_from->Mask());
		ic->SetBitmapsOwnedExternally(ETrue);
		iIconlist->AppendL( ic );
	}

	iListBoxArray=CPresenceArray::NewL(iCallLog);
	iNameArray=CNameArray::NewL(iCallLog);

	iListbox=new (ELeave) doublelinebox(iCallLog, aLog);
	iListbox->SetContainerWindowL(*this);
	iListbox->ConstructL(iNameArray, iListBoxArray, this, EAknListBoxMarkableList);
	iListbox->SetItemHeightL(38);
	iListbox->View()->SetMatcherCursor(EFalse);
	iListbox->ItemDrawer()->FormattedCellData()->SetIconArray(iIconlist);
	iListbox->SetListBoxObserver(this);
	iListbox->Model()->SetItemTextArray(iNameArray);
	iListbox->Model()->SetOwnershipType(ELbmDoesNotOwnItemArray);
	iListbox->CreateScrollBarFrameL(ETrue);
	iListbox->ScrollBarFrame()->SetScrollBarVisibilityL( CEikScrollBarFrame::EOff, CEikScrollBarFrame::EAuto);

	handle_visibility();

	SetRect(aRect);
	ActivateL();
}


CContextCallLogContainer::~CContextCallLogContainer()
{
	CALLSTACKITEM_N(_CL("CContextCallLogContainer"), _CL("~CContextCallLogContainer"));
	if (iCallLog) {
		iCallLog->RemoveObserverL(this);
	}
	
	delete iListbox;
	delete iNameArray;
	delete iListBoxArray;
	delete iEmptyListboxLabel;
}

void CContextCallLogContainer::SizeChanged()
{
	CALLSTACKITEM_N(_CL("CContextCallLogContainer"), _CL("SizeChanged"));

	if (iListbox)
	{
		iListbox->SetRect(Rect());
	}
}


TInt CContextCallLogContainer::CountComponentControls() const
{
	CALLSTACKITEM_N(_CL("CContextCallLogContainer"), _CL("CountComponentControls"));

	return 2; 
}

CCoeControl* CContextCallLogContainer::ComponentControl(TInt aIndex) const
{
	CALLSTACKITEM_N(_CL("CContextCallLogContainer"), _CL("ComponentControl"));
	
	switch ( aIndex )
        {
		case 0:
			return iListbox;
		case 1:
			return iEmptyListboxLabel;
		default:
			return NULL;
        }
}

void CContextCallLogContainer::Draw(const TRect& aRect) const
{
	CALLSTACKITEM_N(_CL("CContextCallLogContainer"), _CL("Draw"));
	
	CWindowGc& gc = SystemGc();
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushColor(KRgbWhite);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.DrawRect(aRect);
}

void CContextCallLogContainer::HandleControlEventL(
    CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
{
	CALLSTACKITEM_N(_CL("CContextCallLogContainer"), _CL("HandleControlEventL"));
	
	// no impl 
} 

void CContextCallLogContainer::HandleListBoxEventL(CEikListBox* aListBox, TListBoxEvent aEventType)
{
	CALLSTACKITEM_N(_CL("CContextCallLogContainer"), _CL("HandleListBoxEventL"));

	if(aListBox == iListbox)
	{
		switch(aEventType)
		{
			case EEventEnterKeyPressed:
				if (get_current_idx() != -1 ) {
					aView->MenuBar()->SetMenuTitleResourceId(R_CONTEXTCALLLOG_MENUBAR_CLICK_ON_ITEM);
					aView->MenuBar()->TryDisplayMenuBarL();
					aView->MenuBar()->SetMenuTitleResourceId(R_CONTEXTCALLLOG_MENUBAR_VIEW1);
				}
				break;
			default:
				break;
		}
	}
}

void CContextCallLogContainer::before_change()
{
	CALLSTACKITEM_N(_CL("CContextCallLogContainer"), _CL("before_change"));
	
	if (! iListbox ) {
		// still constructing
		return;
	}
}

void CContextCallLogContainer::exiting()
{
	CALLSTACKITEM_N(_CL("CContextCallLogContainer"), _CL("exiting"));
	
	iCallLog=0;
}

void CContextCallLogContainer::contents_changed()
{
	CALLSTACKITEM_N(_CL("CContextCallLogContainer"), _CL("contents_changed"));
	
	if (!iListbox ) { return; }
	iListbox->HandleItemRemovalL();
	handle_visibility();
	DrawNow();
}

TKeyResponse CContextCallLogContainer::OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType)
{
	CALLSTACKITEM_N(_CL("CContextCallLogContainer"), _CL("OfferKeyEventL"));

	if (aKeyEvent.iCode==JOY_LEFT || aKeyEvent.iCode == JOY_RIGHT)
	{
		return EKeyWasNotConsumed;
	} 
	        
	if ( iListbox )
        {
		if (aKeyEvent.iCode==JOY_DOWN || aKeyEvent.iCode == JOY_UP || aKeyEvent.iCode == JOY_CLICK)
		{
			return iListbox->OfferKeyEventL(aKeyEvent, aType);
		} 
		if ( (aKeyEvent.iCode==KEY_CALL) && (get_current_idx() != -1) )
		{
			aView->HandleCommandL(EContextCallLogCmdCall);
			return EKeyWasConsumed;
		}
		if ( (aKeyEvent.iCode==KEY_C) && (get_current_idx() != -1) )
		{
			aView->HandleCommandL(EContextCallLogCmdDelete);
			return EKeyWasConsumed;			
		}
		return iListbox->OfferKeyEventL(aKeyEvent, aType);
        }
	else
        {
		return EKeyWasNotConsumed;
        }
}

void CContextCallLogContainer::show_presence_details_current()
{
	CALLSTACKITEM_N(_CL("CContextCallLogContainer"), _CL("show_presence_details_current"));
	
	TInt current_index = get_current_idx();
	if (current_index < 0) return;

	contact * c = iCallLog->GetContact(current_index);
	if (c == NULL || c->presence == NULL) return;

	TBuf<128> name;

	if (c->first_name) name.Append(*(c->first_name));
	
	if (aLog) 
	{
		aLog->write_time();
		aLog->write_to_output(_L("Showing pres. details of "));
		aLog->write_to_output(name);
		aLog->write_nl();
	}
	((CContextCallLogAppUi *)(iEikonEnv->AppUi()))->DisplayPresenceDetailsL(name, c->presence);
}

void CContextCallLogContainer::show_call_details_current()
{
	CALLSTACKITEM_N(_CL("CContextCallLogContainer"), _CL("show_call_details_current"));
	
	if (get_current_idx() != -1)
	{
		//TPtrC16 event=iNameArray->MdcaPoint(get_current_idx());
		CLogEvent * ev = iCallLog->get_event(get_current_idx());

		TLocale locale;
		TTime tt=ev->Time();
		TTimeIntervalSeconds offset(locale.UniversalTimeOffset());
		tt+=offset;
		if (locale.QueryHomeHasDaylightSavingOn()) {
			TTimeIntervalHours ds(1);
			tt+=ds;
		}
		TDateTime t=tt.DateTime();
				
		HBufC * msg = CEikonEnv::Static()->AllocReadResourceL(R_CALL_DETAIL_TEMPLATE);
		CleanupStack::PushL(msg);
		
		TBuf<500> temp;

		TBuf<20> number = _L(" ");
		number.Append(ev->Number());
		TBuf<50> remote_party = _L(" ");
		remote_party.Append(ev->RemoteParty());

		temp.Format(msg->Des(), &remote_party, 
					&number, 
					(TInt)t.Day()+1, 
					(TInt)t.Month()+1,
					(TInt)t.Hour(), 
					(TInt)t.Minute() );
		CAknMessageQueryDialog * note = CAknMessageQueryDialog::NewL(temp);
		CleanupStack::PushL(note);
		note->ExecuteLD(R_CALL_DETAIL_DIALOG);
		CleanupStack::Pop(note);
		CleanupStack::PopAndDestroy(msg); // msg
	}
}

TInt CContextCallLogContainer::get_current_idx()
{
	CALLSTACKITEM_N(_CL("CContextCallLogContainer"), _CL("get_current_idx"));
	
	if (iListbox->Model()->NumberOfItems())
	{
		return iListbox->CurrentItemIndex();
	}
	return -1;
}

void CContextCallLogContainer::handle_visibility()
{
	CALLSTACKITEM_N(_CL("CContextCallLogContainer"), _CL("handle_visibility"));
	
	if (iListbox->Model()->NumberOfItems() == 0)
	{
		iEmptyListboxLabel->SetSize(iEmptyListboxLabel->MinimumSize());
	}
	else
	{
		iListbox->View()->SetCurrentItemIndex(0);
		iEmptyListboxLabel->SetSize(TSize(0,0));
	}
}