#include "ContextCallLogDocument.h"
#include "ContextCallLogAppUi.h"
#include "settings.h"

#include "bb_settings.h"
#include "cl_settings.h"

CContextCallLogDocument::CContextCallLogDocument(CEikApplication& aApp)
: CAknDocument(aApp)    
    {
    }

CContextCallLogDocument::~CContextCallLogDocument()
{
	delete iContext;
}

// EPOC default constructor can leave.
void CContextCallLogDocument::ConstructL()
{
	iContext=CApp_context::NewL(false, _L("call_log"));
	
	
#ifndef __WINS__
	TParsePtrC parse(Application()->DllName());
	iContext->SetAppDir(parse.DriveAndPath());
#else
	iContext->SetAppDir(_L("c:\\system\\apps\\contextcalllog\\"));
#endif
	iContext->SetDataDir(_L("c:\\system\\data\\context\\"), EFalse);
	CBlackBoardSettings* s=CBlackBoardSettings::NewL(*iContext, iNoDefaults, KCLSettingsTuple);

	iContext->SetSettings(s);
}

CContextCallLogDocument* CContextCallLogDocument::NewL(CEikApplication& aApp)     
{
	CContextCallLogDocument* self = new (ELeave) CContextCallLogDocument( aApp );
	CleanupStack::PushL( self );
	self->ConstructL();
	CleanupStack::Pop();

	return self;
}

CEikAppUi* CContextCallLogDocument::CreateAppUiL()
    {
    return new (ELeave) CContextCallLogAppUi(*iContext);
    }


