// INCLUDE FILES
#include  <aknviewappui.h>
#include  <avkon.hrh>
#include  <ContextCallLog.rsg>
#include  "ContextCallLogView.h"
#include  "ContextCallLogContainer.h"
#include "contextcalllog.hrh"
#include <aknmessagequerydialog.h> 
#include <cpbkmemoryentryadditemdlg.h> 
#include <cpbkfieldsinfo.h> 
#include <cpbkcontactitem.h>

#ifndef NO_CPBKSINGLEENTRYFETCHDLG_H
#include <cpbksingleentryfetchdlg.h>
#endif

#include "ContextCallLogAppUi.h"
#include <flogger.h>

/*
 * Concepts:
 * !Shared data client access!
 * !Modifying Contacts!
 */

/*
 * reduce dependacies on sendo -MR
#ifndef NO_SHAREDDATACLIENT_H
#include <sharedDataI.h>
#else
*/

// reverse-engineered from COMMONENGINE.LIB
class CSharedDataI : public CBase {
public:
        IMPORT_C virtual  ~CSharedDataI(void);
        IMPORT_C void  AddCallBackL(class TCallBack const &, class TDesC16 const &);
        IMPORT_C void  AddNotify(class TDesC16 const &);
        IMPORT_C int  AddToValue(class TDesC16 const &, int &);
        IMPORT_C void  CancelSignal(class TDesC16 const &);
        IMPORT_C int  Get(class TDesC16 const &, int &);
        IMPORT_C int  Get(class TDesC16 const &, double &);
        IMPORT_C int  Get(class TDesC16 const &, class TDes16 &);
        IMPORT_C static class CSharedDataI *  NewL(class TUid const &, int);
        IMPORT_C int  Set(class TDesC16 const &, class TDesC16 const &);
        IMPORT_C int  Set(class TDesC16 const &, int &);
        IMPORT_C int  Set(class TDesC16 const &, double &);
        IMPORT_C int  Signal(class TDesC16 const &);
};
//#endif

const TInt KUidNewMisCallDataValue=0x101f4cd5;
const TUid KUidNewMisCallData={KUidNewMisCallDataValue};

void CContextCallLogView::ConstructL(TUid viewId)
{
	iViewId = viewId;
	BaseConstructL( R_CONTEXTCALLLOG_VIEW1 );

	if (iViewId == KReceivedViewId)
	{
		iTitle=CEikonEnv::Static()->AllocReadResourceL(R_RECEIVED_TITLE);
		iEmptyListboxLabel=CEikonEnv::Static()->AllocReadResourceL(R_NO_RECEIVED_LABEL);
	} 
	else if (iViewId == KDialledViewId)
	{
		iTitle=CEikonEnv::Static()->AllocReadResourceL(R_DIALLED_TITLE);
		iEmptyListboxLabel=CEikonEnv::Static()->AllocReadResourceL(R_NO_DIALLED_LABEL);
	}
	else
	{
		iTitle=CEikonEnv::Static()->AllocReadResourceL(R_MISSED_TITLE);
		iEmptyListboxLabel=CEikonEnv::Static()->AllocReadResourceL(R_NO_MISSED_LABEL);
	}


}

CContextCallLogView::~CContextCallLogView()
{
	if ( iContainer )
        {
		AppUi()->RemoveFromViewStack( *this, iContainer );
        }
	delete iTitle;
	delete iEmptyListboxLabel;
	delete iContainer;
	delete iSendAppUi;
}

TUid CContextCallLogView::Id() const
{
	return iViewId;
}


void CContextCallLogView::HandleCommandL(TInt aCommand)
{   
	switch ( aCommand )
	{
		case EAknSoftkeyBack:
		{
			AppUi()->HandleCommandL(EAknSoftkeyBack);
			break;
		}
		case EContextCallLogCmdCall:
		{
			TPtrC no(aCallLog->get_phone_no(iContainer->get_current_idx()));
			if (no!=KNullDesC) aPhoneHelper.make_callL(no);
			break;
		}
		case EContextCallLogCmdPresenceDetails:
		{
			iContainer->show_presence_details_current();
			break;
		}
		case EContextCallLogCmdCallDetails:
		{
			iContainer->show_call_details_current();
			break;
		}
		
		case EContextCallLogCmdCreateContact:
		{
			CArrayPtrFlat<CPbkFieldInfo> * infoArray = new (ELeave) CArrayPtrFlat<CPbkFieldInfo>(20);
			CleanupStack::PushL(infoArray);
			
			for (int i=0; i<aCallLog->get_engine()->FieldsInfo().Count(); i++)
			{
				if ( ((aCallLog->get_engine()->FieldsInfo())[i])->IsPhoneNumberField()  )
				{
					infoArray->AppendL((aCallLog->get_engine()->FieldsInfo())[i]);
				}
			}
			CPbkItemTypeSelectCreateNew * dlg = new (ELeave) CPbkItemTypeSelectCreateNew;
			CleanupStack::PushL(dlg);
			CPbkFieldInfo * fieldInfo = dlg->ExecuteLD(*infoArray) ;
			CleanupStack::Pop(dlg);

			if (fieldInfo != 0)
			{
				TPtrC no(aCallLog->get_phone_no(iContainer->get_current_idx()));
				aPhoneHelper.show_editor(-1, false, -1, fieldInfo, no);
			}
			
			CleanupStack::PopAndDestroy(infoArray);
			break;
		}

		case EContextCallLogCmdUpdateContact:
		{
#ifndef NO_CPBKSINGLEENTRYFETCHDLG_H
			CPbkSingleEntryFetchDlg::TParams p; // = CPbkSingleEntryFetchDlg::TParams();
			p.iPbkEngine = aCallLog->get_engine();
					
			CPbkSingleEntryFetchDlg * anotherDlg = CPbkSingleEntryFetchDlg::NewL(p);
			if (anotherDlg->ExecuteLD())
			{
				TInt contactId = p.iSelectedEntry;
			
				CArrayPtrFlat<CPbkFieldInfo> * infoArray = new (ELeave) CArrayPtrFlat<CPbkFieldInfo>(20);
				CleanupStack::PushL(infoArray);
			
				for (int i=0; i<aCallLog->get_engine()->FieldsInfo().Count(); i++)
				{
					if ( ((aCallLog->get_engine()->FieldsInfo())[i])->IsPhoneNumberField()  )
					{
						infoArray->AppendL((aCallLog->get_engine()->FieldsInfo())[i]);
					}
				}
			
				CPbkItemTypeSelectAddToExisting * dlg = new (ELeave) CPbkItemTypeSelectAddToExisting;
				CleanupStack::PushL(dlg);
				CPbkFieldInfo * fieldInfo = dlg->ExecuteLD(*infoArray) ;
				CleanupStack::Pop(dlg);

				if (fieldInfo != 0)
				{
					TPtrC no(aCallLog->get_phone_no(iContainer->get_current_idx()));
					aPhoneHelper.show_editor(contactId, false, -1, fieldInfo, no);
				}
			
				CleanupStack::PopAndDestroy(infoArray);
			}
#endif
			break;
		}

		case EContextCallLogCmdCreateSms:
		{
			TPtrC no(aCallLog->get_phone_no(iContainer->get_current_idx()));
			HBufC * name = aCallLog->GetContact( iContainer->get_current_idx() )->first_name;
				
			if (no!=KNullDesC)
			{
				CDesCArrayFlat* recip=new CDesCArrayFlat(1);
				CleanupStack::PushL(recip);
				CDesCArrayFlat* alias=new CDesCArrayFlat(1);
				CleanupStack::PushL(alias);
				
				recip->AppendL(no);
				alias->AppendL(*name);
				aPhoneHelper.send_sms(recip, alias);

				CleanupStack::PopAndDestroy(2); // recip, alias
			}
			break;
		}

		case EContextCallLogCmdCreateMms:
		{
			TPtrC no(aCallLog->get_phone_no(iContainer->get_current_idx()));

			HBufC * name = aCallLog->GetContact( iContainer->get_current_idx() )->first_name;
				
			if (no!=KNullDesC)
			{
				CDesCArrayFlat* recip=new CDesCArrayFlat(1);
				CleanupStack::PushL(recip);
				CDesCArrayFlat* alias=new CDesCArrayFlat(1);
				CleanupStack::PushL(alias);
				
				recip->AppendL(no);
				alias->AppendL(*name);
				aPhoneHelper.send_mms(recip, alias);

				CleanupStack::PopAndDestroy(2); // recip, alias
			}
			break;
		}
		case EContextCallLogCmdDelete:
		{
			HBufC * message = CEikonEnv::Static()->AllocReadResourceLC(R_DELETE_MESSAGE);
		        CAknMessageQueryDialog * dlg = CAknMessageQueryDialog::NewL(*message);
			CleanupStack::PushL(dlg);
			dlg->PrepareLC(R_CONFIRMATION_QUERY);
			CleanupStack::Pop(dlg);
			if ( dlg->RunLD() )
			{
				aCallLog->DeleteEvent(iContainer->get_current_idx());
			}
			CleanupStack::PopAndDestroy(); //message
			break;
		}
		case EContextCallLogCmdUseNumber:
		{
			TPtrC no(aCallLog->get_phone_no(iContainer->get_current_idx()));

			if (no != KNullDesC)
			{
			
				HBufC * prompt = CEikonEnv::Static()->AllocReadResourceLC(R_NUMBER);
				const TInt NUMBER_LENGTH=100;
				HBufC* textData=HBufC::NewL(NUMBER_LENGTH);
				CleanupStack::PushL(textData);
				textData->Des().Append(no);
				TPtr16 p=textData->Des();
				CAknTextQueryDialog* dlg = new(ELeave) CAknTextQueryDialog(p, *prompt);
				CleanupStack::PushL(dlg);
				dlg->SetMaxLength(NUMBER_LENGTH);
				CleanupStack::Pop();
				if (dlg->ExecuteLD(R_CONTEXTCALLLOG_USENUMBER) && textData->Length())
				{
					aPhoneHelper.make_callL(no);
				}
				CleanupStack::PopAndDestroy(2); // prompt, textdata
			}
			break;
		}

		case EContextCallLogCmdClear:
		{
			HBufC * msg; 
			if (iViewId == KReceivedViewId)
			{
				msg = CEikonEnv::Static()->AllocReadResourceLC(R_CLEAR_RECEIVED);
			}
			else if (iViewId == KDialledViewId)
			{
				msg = CEikonEnv::Static()->AllocReadResourceLC(R_CLEAR_DIALLED);
			}
			else
			{
				msg = CEikonEnv::Static()->AllocReadResourceLC(R_CLEAR_MISSED);
			}
		                               
			CAknMessageQueryDialog * dlg = CAknMessageQueryDialog::NewL(*msg);
			CleanupStack::PushL(dlg);
			dlg->PrepareLC(R_CONFIRMATION_QUERY);
			CleanupStack::Pop(dlg);
			
			if ( dlg->RunLD() )
			{
				aCallLog->ClearEventList();
			}
			CleanupStack::PopAndDestroy(); // msg
			break;
		}
		default:
		{
			AppUi()->HandleCommandL( aCommand );
			break;
		}
	}
}

void CContextCallLogView::HandleClientRectChange()
{
	if ( iContainer )
        {
		iContainer->SetRect( ClientRect() );
        }
}

void CContextCallLogView::DynInitMenuPaneL(TInt aResourceId, CEikMenuPane* aMenuPane)
{
	if (aResourceId == R_CONTEXTCALLLOG_VIEW1_MENU )
	{
		if ( iContainer->get_current_idx() != -1 )
		{
			aMenuPane->SetItemDimmed(EContextCallLogCmdDelete, EFalse);
			aMenuPane->SetItemDimmed(EContextCallLogCmdClear, EFalse);
			aMenuPane->SetItemDimmed(EContextCallLogCmdCallDetails, EFalse);
			
			if ( aCallLog->GetContact(iContainer->get_current_idx())->id != -1 )
			{
				aMenuPane->SetItemDimmed(EContextCallLogCmdUseNumber, EFalse);
				aMenuPane->SetItemDimmed(EContextCallLogCmdCall, EFalse);
				aMenuPane->SetItemDimmed(EContextCallLogMenuMsg, EFalse);
				aMenuPane->SetItemDimmed(EContextCallLogMenuContact, EFalse);
							
				if ( aCallLog->GetContact(iContainer->get_current_idx())->presence == 0)
				{
					aMenuPane->SetItemDimmed(EContextCallLogCmdPresenceDetails, ETrue);
				}
				else
				{
					aMenuPane->SetItemDimmed(EContextCallLogCmdPresenceDetails, EFalse);
				}
			}
			else
			{
				aMenuPane->SetItemDimmed(EContextCallLogCmdCall, ETrue);
				aMenuPane->SetItemDimmed(EContextCallLogMenuMsg, ETrue);
				aMenuPane->SetItemDimmed(EContextCallLogMenuContact, ETrue);
				aMenuPane->SetItemDimmed(EContextCallLogCmdUseNumber, ETrue);
				aMenuPane->SetItemDimmed(EContextCallLogCmdPresenceDetails, ETrue);
			}
			
			
		}
		else
		{
			aMenuPane->SetItemDimmed(EContextCallLogCmdCallDetails, ETrue);
			aMenuPane->SetItemDimmed(EContextCallLogCmdCall, ETrue);
			aMenuPane->SetItemDimmed(EContextCallLogMenuMsg, ETrue);
			aMenuPane->SetItemDimmed(EContextCallLogCmdClear, ETrue);
			aMenuPane->SetItemDimmed(EContextCallLogCmdDelete, ETrue);
			aMenuPane->SetItemDimmed(EContextCallLogMenuContact, ETrue);
			aMenuPane->SetItemDimmed(EContextCallLogCmdUseNumber, ETrue);
			aMenuPane->SetItemDimmed(EContextCallLogCmdPresenceDetails, ETrue);
		}
	} else if (aResourceId == R_CONTEXTCALLLOG_MENUBAR_CLICK_ON_ITEM_MENU)
	{
		if ( aCallLog->GetContact(iContainer->get_current_idx())->presence == 0)
		{
			aMenuPane->SetItemDimmed(EContextCallLogCmdPresenceDetails, ETrue);
		}
		else
		{
			aMenuPane->SetItemDimmed(EContextCallLogCmdPresenceDetails, EFalse);
		}
	}
}


void CContextCallLogView::DoActivateL(
   const TVwsViewId& /*aPrevViewId*/,TUid /*aCustomMessageId*/,
   const TDesC8& /*aCustomMessage*/)
{
	RDebug::Print(_L("Activate"));

	mailbox_defined = aPhoneHelper.mailbox_defined();
	
	if (iViewId == KReceivedViewId)
	{
		((CContextCallLogAppUi*)AppUi())->SetTab(EContextCallLogReceivedTab);
		aCallLog->SetReceivedFilter();		
	}
	else if (iViewId == KDialledViewId)
	{
		((CContextCallLogAppUi*)AppUi())->SetTab(EContextCallLogDialledTab);
		aCallLog->SetDialledFilter();
	}
	else
	{
		((CContextCallLogAppUi*)AppUi())->SetTab(EContextCallLogMissedTab);
		aCallLog->SetMissedFilter();

		_LIT(KNewMisCall, "NewMisCall");
		CSharedDataI * shData = CSharedDataI::NewL(KUidNewMisCallData, EFalse);
		CleanupStack::PushL(shData);
		TInt zero = 0;

		TInt err = shData->Set(KNewMisCall, zero);

		CleanupStack::PopAndDestroy();

	}
	aCallLog->refresh();

	if (!iContainer)
        {
		iContainer = new (ELeave) CContextCallLogContainer;
		iContainer->SetMopParent(this);
		iContainer->ConstructL( ClientRect(), aCallLog, aLog, aIconlist, this, iTitle, iEmptyListboxLabel );
		AppUi()->AddToStackL( *this, iContainer );
        } 
}

void CContextCallLogView::DoDeactivate()
{
	RDebug::Print(_L("DeActivate"));
	if ( iContainer )
        {
		AppUi()->RemoveFromViewStack( *this, iContainer );
        }
    	delete iContainer;
	iContainer = NULL;
}

void CContextCallLogView::exiting()
{
	if (iContainer) iContainer->exiting();
}
