/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


//CContextClientSession.h


#ifndef __CONTEXTCLIENTSESSION_H__
#define __CONTEXTCLIENTSESSION_H__

#include <e32base.h>

class RContextClientSession : public RSessionBase
{
public:
	IMPORT_C RContextClientSession();
	IMPORT_C TInt ConnectToContextServer();
	IMPORT_C TVersion Version() const;
	
	IMPORT_C void MsgConnectToPresenceServer(const TDesC & username, 
		const TDesC & password, const TDesC & server, TUint32 accessPointId, TRequestStatus& aStatus);
	IMPORT_C void MsgTerminateContextServer(TRequestStatus& aStatus);
	IMPORT_C void MsgRequestPresenceInfo(TDes & contact, TDes & presenceInfo, TTime & send_timestamp, TRequestStatus& aStatus);
	IMPORT_C void MsgRequestPresenceNotification(TDes & contact, TDes & presenceInfo, TTime & send_timestamp, TRequestStatus& aStatus);
	IMPORT_C void MsgUpdateUserPresence(TDesC & info, TRequestStatus& aStatus);
	IMPORT_C void MsgSuspendConnection(TRequestStatus& aStatus);
	IMPORT_C void MsgResumeConnection(TRequestStatus& aStatus);

	IMPORT_C void MsgRequestMessageNotification(TDes & contact, TDes& subject, TDes & message, TRequestStatus& aStatus);
	
	IMPORT_C void Cancel() const;
private: 
	TPtr8   iTimeBuffer;
};

#endif // __TIMESERVERSESSION_H__

