/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


//ClientRequestHandler.cpp

#include <e32svr.h>
#include "ClientRequestHandler.h"
#include "ContextCommon.h"
#include <flogger.h>

#include <eikenv.h>


EXPORT_C CClientRequestHandler * CClientRequestHandler::NewL(MRequestHandlerObserver& aObserver)
{
    	CClientRequestHandler * self = NewLC(aObserver);
    	CleanupStack::Pop();
    	return(self) ;
}

EXPORT_C CClientRequestHandler * CClientRequestHandler ::NewLC(MRequestHandlerObserver& aObserver)
{
	CClientRequestHandler * self = new (ELeave) CClientRequestHandler (aObserver);
    	CleanupStack::PushL(self);
    	self->ConstructL();
    	return self;
}

void CClientRequestHandler::ConstructL()
{
		
}

CClientRequestHandler ::CClientRequestHandler (MRequestHandlerObserver& aObserver) : 
	CCheckedActive(EPriorityStandard, _L("ContextCommon::CClientRequestHandler")), iObserver(aObserver)
{
    	CActiveScheduler::Add(this);
}

EXPORT_C CClientRequestHandler ::~CClientRequestHandler ()
{
	Cancel(); 
    	iSession.Close();
}

void CClientRequestHandler::CheckedRunL()
{
	if (iStatus != ECSRequestCompleted) 
	{
		if (iStatus == ECSIdentificationError) {CEikonEnv::Static ()->AlertWin (_L("ID Error"));}	
		if (iStatus == ECSServerUnreachable)   {CEikonEnv::Static ()->AlertWin (_L("Server Unreachable"));}	
	
		return;
	}

	switch (current_state)
	{
		case EPhaseIdle:
			break;

		case EPhaseWaitingForPresenceInfo:
			iObserver.HandleNewPresenceInfo();
			RequestPresenceInfoNotification();
			break;

		case EPhaseWaitingForConnectionToPresenceServer:
			iObserver.HandleConnectedToPresenceServer();
			current_state = EPhaseIdle;
			break;

		case EPhaseWaitingForDisconnectionFromPresenceServer:
			iObserver.HandleDisconnectedFromPresenceServer();
			current_state = EPhaseIdle;
			break;

		case EPhaseWaitingForServerToTerminate:
			current_state = EPhaseIdle;
			break;

		case EPhaseResumingConnection:
			iObserver.HandleConnectedToPresenceServer();
			current_state = EPhaseIdle;
			break;

		case EPhaseSuspendingConnection:
			iObserver.HandleDisconnectedFromPresenceServer();
			current_state = EPhaseIdle;
			break;

		case EPhaseUpdatingUserInfo:
			iObserver.HandleUserPresenceUpdated();
			current_state = EPhaseIdle;
			break;

		default:
			ASSERT(0) ; // Unexpected error
			break;
	}

}

EXPORT_C void CClientRequestHandler::CancelRequest()
{
    	Cancel() ;
}

void CClientRequestHandler::DoCancel()
{
	iSession.Cancel();
}
 
EXPORT_C TPtrC  CClientRequestHandler::GetPresenceInfo() const
{
	return TPtrC(presenceInfo);
}

EXPORT_C TInt CClientRequestHandler::ConnectToContextServer()
{
	// will return KErrNotFound if no ContextServer was found.
	// or any System Error if session could not be created 
	// or KErrNone if everything was fine :)
	return iSession.ConnectToContextServer();
}

//-------------------------------------------------------------
// - Requests from ContextClient to ContextServer -------------
//-------------------------------------------------------------

EXPORT_C void CClientRequestHandler::ConnectToPresenceServer(TDesC & username, TDesC & password, TDesC & server, TUint32 accessPointId)
{
	if (!IsActive())
	{
      		current_state = EPhaseWaitingForConnectionToPresenceServer;
		iSession.MsgConnectToPresenceServer(username, password, server, accessPointId, iStatus);
        	SetActive();
	}	
}

EXPORT_C void CClientRequestHandler::SuspendConnectionWithPresenceServer()
{
	if (IsActive())
	{
		Cancel();
	}
	current_state = EPhaseSuspendingConnection;
	iSession.MsgSuspendConnection(iStatus);
      	SetActive();
}

EXPORT_C void CClientRequestHandler::ResumeConnectionWithPresenceServer()
{
	if (!IsActive())
	{
      		current_state = EPhaseResumingConnection;
		iSession.MsgResumeConnection(iStatus);
        	SetActive();
	}
}

EXPORT_C void CClientRequestHandler::TerminateContextServer()
{
	if (IsActive())
	{
		Cancel();
	}
	current_state = EPhaseWaitingForServerToTerminate;
	iSession.MsgTerminateContextServer(iStatus);
	SetActive();
}

EXPORT_C void CClientRequestHandler::RequestPresenceInfoNotification()
{
	if(!IsActive())
	{
		TTime t;
		current_state = EPhaseWaitingForPresenceInfo;
		iSession.MsgRequestPresenceNotification(contact, presenceInfo, t, iStatus);
		SetActive();
	}	
}

EXPORT_C void CClientRequestHandler::UpdateUserPresence(TDesC & info)
{
	if(!IsActive())
	{
		current_state = EPhaseUpdatingUserInfo;
		iSession.MsgUpdateUserPresence(info,iStatus);
		SetActive();
	}	
}