/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


// ContextCommon.h


#ifndef __CONTEXTCOMMON__
#define __CONTEXTCOMMON__

#include <e32base.h>


//--------------------- SERVER PANICS --------------------

//Panic Category
_LIT(KContextServer, "ContextServer");

//Panic Codes
enum TContextServPanic
{
	ECSBadRequest,
	ECSBadDescriptor,
	ECSSrvCreateServer,
    	ECSCreateTrapCleanup
};


//--------------------- SERVER PARAM --------------------

_LIT(KContextServerName,"myContextServer");
_LIT(KContextServerSemaphoreName, "AmyContextServerSemaphore");


//the server version. A version must be specified when 
//creating a session with the server
const TUint KContextServMajorVersionNumber=0;
const TUint KContextServMinorVersionNumber=1;
const TUint KContextServBuildVersionNumber=1;


//opcodes used in message passing between client and server
enum TContextServRqst
{
	ETerminateContextServer,
	EConnectToPresenceServer,
	EDisconnectFromPresenceServer,
	ERequestPresenceInfo,
	ERequestPresenceNotification,
	ERequestMessageNotification,
	EUpdateUserPresence,
	ESuspendConnection,
	EResumeConnection,
		
	ECancel

};

//opcodes used by server to indicate which asynchronous service
//has completed
enum TContextServRqstComplete
{
	ECSRequestCompleted = 1,
	ECSIdentificationError = -1,
	ECSServerUnreachable = -2,
	ECSBufferTooSmall = -3,
	EContextServerTerminated = -4
};


#endif // __CONTEXTCOMMON__

