/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(APP_CONTEXT_H_INCLUDED)
#define APP_CONTEXT_H_INCLUDED 1

// #define FUNCTION_LEVEL_STATISTICS 1

#include <e32std.h>
class RFs;
class CCnvCharacterSetConverter;
class RPhone;
class RTelServer;
class RBasicGsmPhone;
class RSystemAgent;
class RWsSession;

#include <aknglobalnote.h> 
#include "checkedactive.h"
#include "errorhandling.h"

#define DESTROY(x) { delete x; x=0; }

IMPORT_C void exceptionhandler(TExcType);

class MSettings;
class CBBSession;
class MBBDataFactory;
class MReporting;
class MCallStack;
class MErrorInfoManager;

class MApp_context_access {
public:
	virtual RFs&	Fs() = 0;
	virtual RSystemAgent&	SysAgent() = 0;
	virtual RTelServer&	TelServer() = 0;
	virtual RBasicGsmPhone&	Phone() = 0;
	virtual CCnvCharacterSetConverter* CC() = 0;
	virtual bool NoSpaceLeft() = 0;
	virtual const TDesC& DataDir() = 0;
	virtual const TDesC& AppDir() = 0;
	virtual MSettings& Settings() = 0;
	virtual RWsSession& Ws() = 0;
	virtual MReporting& Reporting() = 0;
	virtual void ReportActiveError(const TDesC& Source,
		const TDesC& Reason, TInt Code) = 0;
	virtual CBBSession* BBSession() = 0;
	virtual MBBDataFactory* BBDataFactory() = 0;
	virtual MErrorInfoManager& ErrorInfoMgr() = 0;
	virtual MCallStack& CallStackMgr() = 0;
};

class MContextBase : public MApp_context_access {
public:
	IMPORT_C MContextBase();
	IMPORT_C MContextBase(MApp_context& Context);
	IMPORT_C virtual ~MContextBase();
	IMPORT_C MApp_context&	AppContext();
	IMPORT_C MApp_context_access&	AppContextAccess();
	IMPORT_C virtual RFs&	Fs();
	IMPORT_C virtual RSystemAgent&	SysAgent();
	IMPORT_C virtual RTelServer&	TelServer();
	IMPORT_C virtual RBasicGsmPhone&	Phone();
	IMPORT_C virtual CCnvCharacterSetConverter* CC();
	IMPORT_C virtual bool NoSpaceLeft();
	IMPORT_C virtual const TDesC& DataDir();
	IMPORT_C virtual const TDesC& AppDir();
	IMPORT_C virtual MSettings& Settings(); 
	IMPORT_C virtual RWsSession& Ws();
	IMPORT_C virtual void ReportActiveError(const TDesC& Source,
		const TDesC& Reason, TInt Code);
	IMPORT_C CBBSession* BBSession();
	IMPORT_C virtual MBBDataFactory* BBDataFactory();
	IMPORT_C virtual MReporting& Reporting();
	IMPORT_C MErrorInfoManager& ErrorInfoMgr();
	IMPORT_C MCallStack& CallStackMgr();
protected:
	EXPORT_C MApp_context*	GetContext() const;
	MApp_context&	iContext;
};

class TCallStackItem {
public:
	IMPORT_C TCallStackItem(const TDesC8& Name, MApp_context* Context);
	IMPORT_C TCallStackItem(const TDesC8& Class, const TDesC8& Func, MApp_context* Context);
	IMPORT_C ~TCallStackItem();
private:
	class MCallStack* iCallStack;
#ifdef FUNCTION_LEVEL_STATISTICS
	TUint		iStartTicks;
#endif
};

IMPORT_C MApp_context* GetContext();


#if 1
#define _CL(X)			(TPtrC8((const TText8 *)(X), sizeof(X)-1))
#define CALLSTACKITEM(X)	TCallStackItem __item(X, GetContext());
#define CALLSTACKITEMSTATIC(X)	TCallStackItem __item(X, ::GetContext());
#define CALLSTACKITEM2(X, Y)	TCallStackItem __item(X, Y);
#define CALLSTACKITEM_N(CLASS, FUNC)	TCallStackItem __item((CLASS), (FUNC), GetContext());
#define CALLSTACKITEMSTATIC_N(CLASS, FUNC)	TCallStackItem __item((CLASS), (FUNC), ::GetContext());
#define CALLSTACKITEM2_N(CLASS, FUNC, CTX)	TCallStackItem __item((CLASS), (FUNC), (CTX));
#else
#define _CL(X)
#define CALLSTACKITEM(X)	
#define CALLSTACKITEMSTATIC(X)	
#define CALLSTACKITEM2(X, Y)	
#endif

IMPORT_C TTime GetTime();

IMPORT_C TBool HasMMC(RFs& aFs);

#endif
