#if !defined(APP_CONTEXT_IMPL_H_INCLUDED)
#define APP_CONTEXT_IMPL_H_INCLUDED 1

#include "app_context.h"
#include <e32std.h>
class MPausable;
class MActiveErrorReporter;



class MApp_context: public MApp_context_access {
public:
	virtual ~MApp_context();
	virtual void SetFileLog(MPausable* log) = 0;
	virtual void SetDataDir(const TDesC& Dir, bool UseMMC) = 0;
	IMPORT_C static MApp_context* Static();

	virtual void SetDebugLog(const TDesC& aDir, const TDesC& aFile) = 0;

private:
	int		refcount;
};

class MDiskSpace {
public:
	virtual void DiskSpaceThreshold(TInt aDrive) = 0;
};

class CDiskSpaceNotifier;

class CApp_context : public MApp_context, public CBase {
public:
	IMPORT_C static CApp_context* NewL(bool aFsOnly=false, const TDesC& Name=KNullDesC);
	virtual ~CApp_context();
	virtual void SetActiveErrorReporter(MActiveErrorReporter* Reporter) = 0;
	virtual void SetSettings(MSettings* Settings) = 0;  // takes ownership
	virtual void SetDataDir(const TDesC& Dir, bool UseMMC) = 0;
	virtual void SetAppDir(const TDesC& Dir) = 0;
	virtual void SetBBSession(CBBSession* BBSession) = 0;
	virtual void SetBBDataFactory(MBBDataFactory* aFactory) = 0;
};


#ifdef __WINS__
IMPORT_C void StartStarterL(const TDesC& StackName, TUid AppUid, bool CheckForRunning, RWsSession& Ws);
#else
IMPORT_C void StartStarterL(const TDesC& StackName, TUid AppUid, bool CheckForRunning);
#endif

#endif
