#ifndef CC_CALLSTACK_H_INCLUDED
#define CC_CALLSTACK_H_INCLUDED 1

class MCallStackVisitor {
public:
	virtual void BeginStack() = 0;
	virtual void VisitItem(const TDesC& Name) = 0;
	virtual void EndStack() = 0;
};

class MCallStack {
public:
	virtual const char* CallStack() = 0;
	virtual TInt PushCallStack(const TDesC8& Name) = 0;
	virtual TInt PushCallStack(const TDesC8& Class, const TDesC8& Func) = 0;
	virtual TPtr8 PopCallStack() = 0;
	virtual void ResetCallStack() = 0;
	virtual HBufC* GetFormattedCallStack(const TDesC& Prefix) = 0;
	virtual void IterateStack(MCallStackVisitor& aVisitor, const char* aStack=0) = 0;
};

#endif

