#ifndef CC_SHAREDDATA_H_INCLUDED
#define CC_SHAREDDATA_H_INCLUDED

/*
 * stripped down shareddataclient
 */

class MSharedDataNotifyHandler {
public:
virtual void HandleNotifyL( const TUid aUid, const TDesC& aKey,
                            const TDesC& aValue ) = 0;
};

class RSharedDataClient : public RSessionBase {
public:
	IMPORT_C RSharedDataClient( MSharedDataNotifyHandler* aHandler );
	IMPORT_C RSharedDataClient();
	IMPORT_C TInt Connect( TInt aPriority = 0 );
	IMPORT_C void Close();
	IMPORT_C TInt Assign( const TUid aUid ) const;
	IMPORT_C TInt GetInt( const TDesC& aKey, TInt& aValue ) const;
	IMPORT_C TInt GetString( const TDesC& aKey, TDes& aValue ) const;
	IMPORT_C TInt SetInt( const TDesC& aKey, TInt aValue );
	IMPORT_C TInt SetString( const TDesC& aKey, const TDesC& aValue );
	IMPORT_C TInt NotifyChange( const TUid aUid, const TDesC* aKey = 0 );
	IMPORT_C void CancelNotify( const TUid aUid, const TDesC* aKey = 0 );
	IMPORT_C void CancelAllNotifies();
private:
	TInt	iDummy[3];
};

#endif
