#ifndef CC_ERRORINFO_H_INCLUDED
#define CC_ERRORINFO_H_INCLUDED 1

#include <e32std.h>
#include "errorinfo.h"
#include "vararg_if_macros.h"
#include "stringarg.h"

/*
 * the error reporting/raising is meannt to work like:
 *
 *	Bug(_L("record disappeared!")).Raise();
 * or
 *
 *	InputErr(_L("invalid number")).TechMsg(_L("validate returned %1", -2)).Raise();
 *
 * or
 *	EnvErr(_L("Cannot make a GPRS connection while roaming")).ErrorCode(ENoGprsWhileRoaming).Raise();
 *
 * localization: TOBEDONE :-(
 *
 */

class MErrorInfoManager {
public:
	virtual void StartErrorWithInfo(TErrorCode aErrorCode,
		const TStringArg& aUserMessage, const TStringArg& aTechMessage,
		TErrorType aErrorType, TSeverity aSeverity) = 0;

	virtual MErrorInfo* GetLastErrorInfo() = 0;
	virtual void ResetLastErrorInfo() = 0;

	INTERFACE_VARARG(UserMsg, MErrorInfoManager&, const TStringArg&);
	// implies virtual MErrorInfoManager& UserMsg(const TStringArg& aArg) = 0;
	INTERFACE_VARARG(TechMsg, MErrorInfoManager&, const TStringArg&);
	// implies virtual MErrorInfoManager& TechMsg(const TStringArg& aArg) = 0;
	virtual MErrorInfoManager& ErrorCode(TErrorCode aErrorCode) = 0;
	virtual MErrorInfoManager& Severity(TSeverity aSeverity) = 0;
	virtual MErrorInfoManager& ErrorType(TErrorType aErrorType) = 0;
	virtual void Raise() = 0;
	virtual void Log() = 0;
};

IMPORT_C MErrorInfoManager& Bug(const TDesC& aTechMsg);
IMPORT_C MErrorInfoManager& Corrupt(const TDesC& aTechMsg);
IMPORT_C MErrorInfoManager& InputErr(const TDesC& aUserMsg);
IMPORT_C MErrorInfoManager& RemoteErr(const TDesC& aTechMsg);
IMPORT_C MErrorInfoManager& EnvErr(const TDesC& aUserMsg);
IMPORT_C MErrorInfoManager& PlainErr(TInt aError);

#define gettext(a) (TPtrC((const TText *)L ## a, sizeof(L##a)/2-1))

#endif
