/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(FILE_OUTPUT_BASE_H_INCLUDED)

#define FILE_OUTPUT_BASE_H_INCLUDED

#include <f32file.h>
#include <charconv.h>
#include <e32std.h>
#include "timeout.h"
#include "list.h"

#include "app_context.h"

IMPORT_C void format_datetime(TDes& buffer, const TTime& time);

class Mfile_output_base : public MContextBase {
public:
	IMPORT_C Mfile_output_base(MApp_context& Context);
	IMPORT_C virtual ~Mfile_output_base();
	IMPORT_C virtual void ConstructL(const TDesC& prefix, bool do_open_file=true);
	IMPORT_C void switch_file();
	IMPORT_C static const TLitC<3> nl;
	IMPORT_C void write_time();
	IMPORT_C void write_time(const TTime& time);
	IMPORT_C virtual void write_to_output(const TDesC& str);
	IMPORT_C virtual void write_to_output(const TDesC8& str);
	IMPORT_C static void make_filename(TDes& into_buffer, const TDesC& dir, const TDesC& prefix);
	IMPORT_C static void make_filename(TDes& into_buffer, const TDesC& dir, const TDesC& prefix, const TDesC& extension);
	IMPORT_C void write_nl();
	TBool	paused;
protected:
	IMPORT_C void open_file(const TDesC& prefix);
	IMPORT_C void close_file();
private:
	RFile file;
	TBuf8<512> buf;
	HBufC* file_prefix;
	TInt state;
	bool	file_is_open;
	bool	has_e_drive;
	TFileName current_file_name;
};

class Cfile_output_base: public Mfile_output_base, public CBase, public MTimeOut
{
public:
	IMPORT_C Cfile_output_base(MApp_context& Context);
	IMPORT_C virtual ~Cfile_output_base();
	IMPORT_C static Cfile_output_base* NewL(MApp_context& Context, const TDesC& prefix, bool do_open_file=true, 
		bool buffered_writes=false);
	IMPORT_C virtual void write_to_output(const TDesC8& str);
	IMPORT_C virtual void write_to_output(const TDesC& str);
	IMPORT_C void log_message(const TDesC8& str);
	IMPORT_C void log_message(const TDesC& str);
private:
	IMPORT_C virtual void ConstructL(const TDesC& prefix, bool do_open_file=true, 
		bool buffered_writes=false);
	IMPORT_C virtual void expired(); // not called
	IMPORT_C virtual void expired(CBase* source); // not called

	CList< HBufC8* > *iBuffers;
	bool	iBuffered;
	CTimeOut*	iTimer;
	bool	iDeleting;
};

#endif
