#ifndef CONTEXT_MUTEXREQUEST_H_INCLUDED
#define CONTEXT_MUTEXREQUEST_H_INCLUDED 1

#include <e32std.h>
#include <e32base.h>
#include "app_context.h"

class CMutexRequest : public CActive, public MContextBase {
public:
	IMPORT_C static CMutexRequest* NewL(MApp_context& Context,
		const TDesC& aName, TTimeIntervalMicroSeconds32 aTimeOut,
		TRequestStatus* aToSignal);
	IMPORT_C ~CMutexRequest();
private:
	void DoCancel();
	void RunL();

	void OpenGlobalL(const TDesC& aName);
	void WaitL(TRequestStatus* aToSignal, TTimeIntervalMicroSeconds32 aTimeOut);

	CMutexRequest(MApp_context& Context);
	void ConstructL();
	RSemaphore	iMutex; TBool	iIsOpen;
	RThread iChild; TBool	iChildIsOpen;
	TRequestStatus*	iRequestStatus;
	TBool	iWaited;
	RThread iParent; TBool iParentIsOpen;
	RTimer	iTimer; TBool iTimerIsOpen;

	friend void WaitLoopL(TAny* aArgs);
};

#endif