/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/
#ifndef CB_PHONEHELPER_H_INCLUDED
#define CB_PHONEHELPER_H_INCLUDED 1

#include <etel.h>
#include "checkedactive.h"
#include <sendui.h>
#include <badesca.h>
#include <cpbkcontactengine.h> 
#include "app_context.h"
#include "file_output_base.h"
#include <cpbkfieldinfo.h>


class phonehelper : public CCheckedActive, MContextBase {
public:
	IMPORT_C phonehelper(Cfile_output_base * log) : CCheckedActive(EPriorityIdle, _L("phonehelper")), aLog(log), iServerOpen(EFalse), iPhoneOpen(EFalse), iLineOpen(EFalse), iCallOpen(EFalse) {}
	IMPORT_C void ConstructL();
	phonehelper();
	IMPORT_C ~phonehelper();
	IMPORT_C TInt make_callL(const TDesC& number);
	IMPORT_C TFileName ExportVCardToFile(TInt ContactId);

public:
	IMPORT_C TBool mailbox_defined();
	IMPORT_C void send_sms(CDesCArrayFlat* recip, CDesCArrayFlat* alias);
	IMPORT_C void send_mms(CDesCArrayFlat* recip, CDesCArrayFlat* alias);
	IMPORT_C void send_email(CDesCArrayFlat* recip, CDesCArrayFlat* alias);
	IMPORT_C void send_as(TUid mtmUid, CArrayFixFlat<TInt> * c);

public:
	IMPORT_C void show_editor(TInt contact_id, bool duplicate, TInt focus_field_index = -1, CPbkFieldInfo * fieldInfo = 0, const TDesC& no = KNullDesC);

private:
	IMPORT_C virtual void DoCancel();
	IMPORT_C virtual void CheckedRunL(); 

private:
	RLine line;
	RPhone phone;
	RTelServer server;
	RCall call;
	CSendAppUi * iSendAppUi;
	Cfile_output_base * aLog;
	TBool iServerOpen;
	TBool iPhoneOpen;
	TBool iLineOpen;
	TBool iCallOpen;
	CPbkContactEngine * iEngine;
	TBool owns_engine;
};

#endif
