#ifndef CC_RAII_H_INCLUDED
#define CC_RAII_H_INCLUDED 1

class RABase {
protected:
	RABase() : iOpen(EFalse), iOnStack(EFalse) { }
	virtual ~RABase() { 
		if (iOnStack) 
			CleanupStack::Pop(); 
	}
	TBool iOpen, iOnStack;
	static void CloseRABase(TAny* p) {
		RABase* b=(RABase*) p;
		b->CloseRA();
	}
	void PutOnStackL() { 
		if (!iOnStack) { 
			iOnStack=ETrue; 
			CleanupStack::PushL(TCleanupItem(&CloseRABase, (TAny*)this));
		} 
	}
	virtual void CloseInner() = 0;
	friend void CloseRABase(TAny* p);
	
public:
	void CloseRA() { 
		if (iOpen) { 
			CloseInner(); iOpen=EFalse; 
		} 
	}
	TBool IsOpen() const { return iOpen; }
};

#endif
