#ifndef CC_RAE32STD_H_INCLUDED
#define CC_RAE32STD_H_INCLUDED 1

#include <e32std.h>
#include "raii.h"

class RAThread : public RThread, public RABase {
public:
	inline void CreateLA(const TDesC& aName,TThreadFunction aFunction,TInt aStackSize,TInt aHeapMinSize,TInt aHeapMaxSize,TAny *aPtr,TOwnerType aType=EOwnerProcess) {
		RABase::CloseRA();
		User::LeaveIfError(Create(aName,aFunction,aStackSize,aHeapMinSize,aHeapMaxSize,aPtr,aType));
		iOpen=ETrue;
		PutOnStackL();
	}
	inline void CreateLA(const TDesC& aName,TThreadFunction aFunction,TInt aStackSize,RHeap* aHeap,TAny* aPtr,TOwnerType aType=EOwnerProcess) {
		RABase::CloseRA();
		User::LeaveIfError(Create(aName,aFunction,aStackSize,aHeap,aPtr,aType));
		iOpen=ETrue;
		PutOnStackL();
	}
	inline void CreateLA(const TDesC& aName,TThreadFunction aFunction,TInt aStackSize,TAny* aPtr,RLibrary* aLibrary,RHeap* aHeap, TInt aHeapMinSize,TInt aHeapMaxSize,TOwnerType aType) {
		RABase::CloseRA();
		User::LeaveIfError(Create(aName,aFunction,aStackSize,aPtr,aLibrary,aHeap,aHeapMinSize,aHeapMaxSize,aType));
		iOpen=ETrue;
		PutOnStackL();
	}
	inline void OpenLA(const TDesC& aFullName,TOwnerType aType=EOwnerProcess) {
		RABase::CloseRA();
		User::LeaveIfError(Open(aFullName,aType));
		iOpen=ETrue;
		PutOnStackL();
	}
	inline void OpenLA(const TFindThread& aFind,TOwnerType aType=EOwnerProcess) {
		RABase::CloseRA();
		User::LeaveIfError(Open(aFind,aType));
		iOpen=ETrue;
		PutOnStackL();
	}
	inline void OpenLA(TThreadId aID,TOwnerType aType=EOwnerProcess) {
		RABase::CloseRA();
		User::LeaveIfError(Open(aID,aType));
		iOpen=ETrue;
		PutOnStackL();
	}
	~RAThread() { RABase::CloseRA(); }
	void CloseInner() { RThread::Close(); }
private:
	void Close() { }
};

class RATimer : public RTimer, public RABase {
public:
	inline void CreateLocalLA() {
		RABase::CloseRA();
		User::LeaveIfError(CreateLocal());
		iOpen=ETrue;
		PutOnStackL();
	}
	~RATimer() { RABase::CloseRA(); }
	void CloseInner() { RTimer::Close(); }
private:
	void Close() { }
};

#endif // CC_RAE32STD_H_INCLUDED
