#ifndef CC_RAF32FILE_H_INCLUDED
#define CC_RAF32FILE_H_INCLUDED 1

#include <f32file.h>
#include "raii.h"

class RAFile : public RFile, public RABase {
public:
	inline void OpenLA(RFs& aFs,const TDesC& aName,TUint aFileMode) {
		RABase::CloseRA();
		User::LeaveIfError(Open(aFs,aName,aFileMode));
		iOpen=ETrue;
		PutOnStackL();
	}
	inline void CreateLA(RFs& aFs,const TDesC& aName,TUint aFileMode) {
		RABase::CloseRA();
		User::LeaveIfError(Create(aFs,aName,aFileMode));
		iOpen=ETrue;
		PutOnStackL();
	}
	inline void ReplaceLA(RFs& aFs,const TDesC& aName,TUint aFileMode) {
		RABase::CloseRA();
		User::LeaveIfError(Replace(aFs,aName,aFileMode));
		iOpen=ETrue;
		PutOnStackL();
	}
	inline void TempLA(RFs& aFs,const TDesC& aPath,TFileName& aName,TUint aFileMode) {
		RABase::CloseRA();
		User::LeaveIfError(Temp(aFs,aPath,aName,aFileMode));
		iOpen=ETrue;
		PutOnStackL();
	}
	~RAFile() { RABase::CloseRA(); }
	void CloseInner() { RFile::Close(); }
private:
	void Close() { }
};

class RAFs : public RFs, public RABase {
public:
	inline void ConnectLA() {
		RABase::CloseRA();
		User::LeaveIfError(Connect());
		iOpen=ETrue;
		PutOnStackL();
	}
	~RAFs() { RABase::CloseRA(); }
	void CloseInner() { RFs::Close(); }
private:
	void Close() { }
};

#endif // CC_RAF32FILE_H_INCLUDED
