#ifndef CC_RAS32FILE_H_INCLUDED
#define CC_RAS32FILE_H_INCLUDED 1

#include <s32file.h>
#include "raii.h"

class RAFileBuf : public RFileBuf, public RABase {
public:
	inline void OpenLA(RFs& aFs,const TDesC& aName,TUint aFileMode) {
		RABase::CloseRA();
		User::LeaveIfError(Open(aFs,aName,aFileMode));
		iOpen=ETrue;
		PutOnStackL();
	}
	inline void CreateLA(RFs& aFs,const TDesC& aName,TUint aFileMode) {
		RABase::CloseRA();
		User::LeaveIfError(Create(aFs,aName,aFileMode));
		iOpen=ETrue;
		PutOnStackL();
	}
	inline void ReplaceLA(RFs& aFs,const TDesC& aName,TUint aFileMode) {
		RABase::CloseRA();
		User::LeaveIfError(Replace(aFs,aName,aFileMode));
		iOpen=ETrue;
		PutOnStackL();
	}
	inline void TempLA(RFs& aFs,const TDesC& aPath,TFileName& aName,TUint aFileMode) {
		RABase::CloseRA();
		User::LeaveIfError(Temp(aFs,aPath,aName,aFileMode));
		iOpen=ETrue;
		PutOnStackL();
	}
	~RAFileBuf() { RABase::CloseRA(); }
	void CloseInner() { RFileBuf::Close(); }
private:
	void Close() { }
};

class RAFileReadStream : public RFileReadStream, public RABase {
public:
	inline void OpenLA(RFs& aFs,const TDesC& aName,TUint aFileMode) {
		RABase::CloseRA();
		User::LeaveIfError(Open(aFs,aName,aFileMode));
		iOpen=ETrue;
		PutOnStackL();
	}
	~RAFileReadStream() { RABase::CloseRA(); }
	void CloseInner() { RFileReadStream::Close(); }
private:
	void Close() { }
};

class RAFileWriteStream : public RFileWriteStream, public RABase {
public:
	inline void OpenLA(RFs& aFs,const TDesC& aName,TUint aFileMode) {
		RABase::CloseRA();
		User::LeaveIfError(Open(aFs,aName,aFileMode));
		iOpen=ETrue;
		PutOnStackL();
	}
	inline void CreateLA(RFs& aFs,const TDesC& aName,TUint aFileMode) {
		RABase::CloseRA();
		User::LeaveIfError(Create(aFs,aName,aFileMode));
		iOpen=ETrue;
		PutOnStackL();
	}
	inline void ReplaceLA(RFs& aFs,const TDesC& aName,TUint aFileMode) {
		RABase::CloseRA();
		User::LeaveIfError(Replace(aFs,aName,aFileMode));
		iOpen=ETrue;
		PutOnStackL();
	}
	inline void TempLA(RFs& aFs,const TDesC& aPath,TFileName& aName,TUint aFileMode) {
		RABase::CloseRA();
		User::LeaveIfError(Temp(aFs,aPath,aName,aFileMode));
		iOpen=ETrue;
		PutOnStackL();
	}
	~RAFileWriteStream() { RABase::CloseRA(); }
	void CloseInner() { RFileWriteStream::Close(); }
private:
	void Close() { }
};

#endif // CC_RAS32FILE_H_INCLUDED
