#ifndef CC_REPORTING_H_INCLUDED
#define CC_REPORTING_H_INCLUDED 1

#include <e32std.h>
#include <aknnotifystd.h>

class MActiveErrorReporter {
public:
	virtual void ReportError(const TDesC& Source,
		const TDesC& Reason, TInt Code) = 0;
};

class MBusyIndicator {
public:
	virtual void ShowBusy(TBool aIsBusy) = 0;
};

class MReporting {
public:
	virtual void DebugLog(const TDesC& aMessage) = 0;
	virtual void DebugLog(const TDesC& aMessage, TInt aCode) = 0;
	virtual void UserErrorLog(const TDesC& aMessage) = 0;
	virtual void UserErrorLog(const TDesC& aMessage, TInt aCode) = 0;
	virtual void UserErrorLog(const TDesC& aMessage, const TDesC& aMessagePart) = 0;
	virtual void UserErrorLog(const TDesC& aMessage, 
		const TDesC& aMessagePart, const TDesC& aMessagePart2) = 0;
	virtual void ShowGlobalNote(TAknGlobalNoteType notetype, const TDesC& msg) = 0;
	virtual void SetActiveErrorReporter(MActiveErrorReporter* Reporter) = 0;

	virtual TBool AddBusyIndicator(MBusyIndicator *aIndicator) = 0;
	virtual void RemoveBusyIndicator(MBusyIndicator *aIndicator) = 0;
	virtual TBool ShowBusy(TBool aIsBusy) = 0;
};

class TAutoBusy {
public:
	IMPORT_C TAutoBusy(MReporting& aReporting);
	IMPORT_C ~TAutoBusy();
private:
	MReporting& iReporting;
	TBool	iPreviousBusy;
	friend void StopBusy(TAny* aPtr);
};

#endif
