/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef SETTINGS_H_INCLUDED
#define SETTINGS_H_INCLUDED 1

#include "db.h"
#include "app_context.h"
#include "symbian_tree.h"

class MDefaultSettings {
public:
	virtual bool GetDefaultL(TInt Setting, TDes& Value) const = 0;
	virtual bool GetDefaultL(TInt Setting, TDes8& Value) const = 0;
	virtual bool GetDefaultL(TInt Setting, TInt& Value) const = 0;
	virtual bool GetDefaultL(TInt Setting, TTime& Value) const = 0;
};

class TNoDefaults: public MDefaultSettings {
private:
	IMPORT_C virtual bool GetDefaultL(TInt Setting, TDes& Value) const;
	IMPORT_C virtual bool GetDefaultL(TInt Setting, TDes8& Value) const;
	IMPORT_C virtual bool GetDefaultL(TInt Setting, TInt& Value) const;
	IMPORT_C virtual bool GetDefaultL(TInt Setting, TTime& Value) const;
};

class MSettings {
public:
	virtual bool GetSettingL(TInt Setting, TDes& Value);
	virtual bool GetSettingL(TInt Setting, TDes8& Value);
	virtual bool GetSettingL(TInt Setting, TInt& Value);
	virtual bool GetSettingL(TInt Setting, TTime& Value);
	// virtual bool GetSettingL(TInt Setting, TBool& Value); TBool is typedeffed to int
	virtual void WriteSettingL(TInt Setting, const TDesC& Value);
	virtual void WriteSettingL(TInt Setting, const TDesC8& Value);
	virtual void WriteSettingL(TInt Setting, const TInt& Value);
	virtual void WriteSettingL(TInt Setting, const TTime& Value);
	// virtual void WriteSettingL(TInt Setting, const TBool& Value); TBool is typedeffed to int
	virtual void NotifyOnChange(TInt Setting, MSettingListener* Listener);
	virtual void CancelNotifyOnChange(TInt Setting, MSettingListener* Listener);
};

enum TSettingDatatype { EEmpty, EString, EString8, EBool, EInt, ETime, EAP, EEnum };
struct TSettingItem {
	TInt			iSettingNo;
	TSettingDatatype	iDatatype;
	const TLitC16<1>::__TText*		iStringDefault;
	TInt			iIntDefault;
	TBool			iDefaultExists;
};

#endif
