#ifndef CC_STRINGARG_H_INCLUDED
#define CC_STRINGARG_H_INCLUDED 1

#include <e32std.h>
#ifndef XmlParse_INCLUDED
#  ifndef __WINS__
typedef wchar_t XML_Char;
#  else
typedef TText16 XML_Char;
#  endif
#endif

/*
 * This class is used to represent generic parameters
 * to error messages. The parameters are just concatenated.
 * 'Normal' users do not need to know about this class, it should
 * just be an implementation detail of MErrorInfoManager::(User|Tech)Message()
 *
 * Note that we have to make this variant-like for the 
 * built-in classes (instead of subclassing) so that something like
 *
 *	void foo(const TStringArg& a);
 * can be called like 
 *	foo(1);
 * while respecting the C++ only-one-user-defined-conversion rule
 *
 * for our own classes we can define an 'operator TStringArg' on the
 * class, which produces an object that uses the custom data and functions
 *
 */

class TStringArg {
public:
	IMPORT_C void AppendToString(TDes& aString) const;
	IMPORT_C virtual TUint Length() const;
	IMPORT_C explicit TStringArg(TUint aArg); 
	// explicit because otherwise conversion from int would be ambiguous
	IMPORT_C TStringArg(TInt aArg);
	IMPORT_C TStringArg(const TDesC& aArg);
	IMPORT_C TStringArg(const XML_Char* aChar);
	IMPORT_C TStringArg(const XML_Char** aCharArr);
	IMPORT_C TStringArg(const void* aCustomData, TInt aLength, 
		void(*aCustomAppend)(const void* aData, TDes& aString));
private:
	IMPORT_C virtual void DoAppendToString(TDes& aString) const;
	IMPORT_C TStringArg();
	enum TType { EInt, EUint, EDes, ECustom, EChar, ECharArr } iType;
	union {
		TUint iUint;
		TInt iInt;
		const TDesC *iDes;
		const void *iCustom;
		const TText16* iChar;
		const TText16** iCharArr;
	} iVal;
	TInt	iCustomLen;
	void(*iCustomAppend)(const void* aData, TDes& aString);
};

#endif
