/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


/*
 * Copyright (c) 1997-1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Silicon Graphics makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */

/*
 * Adapted from the SGI auto_ptr implementation by Sander van der wal, mBrain Software.
 *
 * A number of declarations have been commented out because
 * - they don't work for the GCC2.7.2 compiler, as used for Release 5
 * - I don't know exactly what they are doing
 *
 * Fortunately the most important things are there.
 *
 */

#ifndef __AUTO_PTR_H__
#define __AUTO_PTR_H__  


#ifndef __E32BASE_H__
#include <e32base.h>
#endif

IMPORT_C void CloseCBaseIndirect(TAny* aPtr);
IMPORT_C void CloseHBufC16Indirect(TAny* aPtr);
IMPORT_C void CloseHBufC8Indirect(TAny* aPtr);

template<class Y> struct auto_ptr_ref
{
  Y* iPtr;
  auto_ptr_ref(Y* aPtr) : iPtr(aPtr) {}
};

/*
class auto_ptr_base
{
protected:
  auto_ptr_base(CBase* aPtr); 
  CBase* iBasePtr;
};
*/

template<class X> class auto_ptr
{
public:  
  typedef X element_type;

  auto_ptr(X* aPtr = 0): iBasePtr(aPtr)
  {
    CleanupStack::PushL(TCleanupItem(CloseCBaseIndirect, (void*)&iBasePtr));
  }  
  
  auto_ptr(auto_ptr& aPtr): iBasePtr(aPtr.release())
  {
    CleanupStack::PushL(TCleanupItem(CloseCBaseIndirect, (void*)&iBasePtr));
  }

  auto_ptr<X>& operator=(auto_ptr<X>& aRhs)
  {
    if (&aRhs != this)
    {
      delete iBasePtr;
      iBasePtr = aRhs.release();
    }
    return (*this); 
  }

  ~auto_ptr() 
  { 
    CleanupStack::Pop();
    delete iBasePtr;
  }

  X& operator *() const { return *(X*)iBasePtr; }
  X* operator ->() const { return (X*)iBasePtr; }
   
  X* get() const { return (X*)iBasePtr; }

  X* release()
 	{ 
    X* result = (X*)iBasePtr;
    iBasePtr = 0;
    return result; 
  }

  void reset(X* aPtr = 0) {
    if ( aPtr != iBasePtr) {
      delete iBasePtr;
      iBasePtr = aPtr;
    }
  }


  auto_ptr(auto_ptr_ref<X> aRef): iBasePtr(aRef.iBasePtr)
  {
    CleanupStack::PushL(TCleanupItem(CloseCBaseIndirect, (void*)&iBasePtr));
  }


  template <class Y> operator auto_ptr_ref<Y>() 
    { return auto_ptr_ref<Y>(this->release()); }

private:
	CBase* iBasePtr;
};

template<> class auto_ptr<HBufC16>
{
public:  

  auto_ptr(HBufC16* aPtr = 0): iPtr(aPtr)
  {
    CleanupStack::PushL(TCleanupItem(CloseHBufC16Indirect, (void*)&iPtr));
  }  
  
  auto_ptr(auto_ptr& aPtr): iPtr(aPtr.release())
  {
    CleanupStack::PushL(TCleanupItem(CloseHBufC16Indirect, (void*)&iPtr));
  }

  auto_ptr<HBufC16>& operator=(auto_ptr<HBufC16>& aRhs)
  {
    if (&aRhs != this)
    {
      delete iPtr;
      iPtr = iPtr = aRhs.release();
    }
    return (*this); 
  }

  ~auto_ptr() 
  { 
    CleanupStack::Pop();
    delete iPtr;
  }

  const TDesC16& operator *() const { return *iPtr; }
  HBufC16* operator ->() const { return iPtr; }
   
  HBufC16* get() const { return iPtr; }

  HBufC16* release()
 	{ 
    HBufC16* result = iPtr;
    iPtr = 0;
	return result; 
  }

  void reset(HBufC16* aPtr = 0) {
    if (aPtr != iPtr) {
      delete iPtr;
      iPtr = aPtr;
    }
  }


  auto_ptr(auto_ptr_ref<HBufC16> aRef): iPtr(aRef.iPtr)
  {
    CleanupStack::PushL(TCleanupItem(CloseHBufC16Indirect, (void*)&iPtr));
  }


  template <class Y> operator auto_ptr_ref<Y>() 
    { return auto_ptr_ref<Y>(this->release()); }
  
private:
  HBufC16* iPtr;  
};

template<> class auto_ptr<HBufC8>
{
public:  

  auto_ptr(HBufC8* aPtr = 0): iPtr(aPtr)
  {
    CleanupStack::PushL(TCleanupItem(CloseHBufC8Indirect, (void*)&iPtr));
  }  
  
  auto_ptr(auto_ptr& aPtr): iPtr(aPtr.release())
  {
    CleanupStack::PushL(TCleanupItem(CloseHBufC8Indirect, (void*)&iPtr));
  }

  auto_ptr<HBufC8>& operator=(auto_ptr<HBufC8>& aRhs)
  {
    if (&aRhs != this)
    {
      delete iPtr;
      iPtr = iPtr = aRhs.release();
    }
    return (*this); 
  }

  ~auto_ptr() 
  { 
    CleanupStack::Pop();
    delete iPtr;
  }

  const TDesC8& operator *() const { return *iPtr; }
  HBufC8* operator ->() const { return iPtr; }
   
  HBufC8* get() const { return iPtr; }

  HBufC8* release()
 	{ 
    HBufC8* result = iPtr;
    iPtr = 0;
	return result; 
  }

  void reset(HBufC8* aPtr = 0) {
    if (aPtr != iPtr) {
      delete iPtr;
      iPtr = aPtr;
    }
  }


  auto_ptr(auto_ptr_ref<HBufC8> aRef): iPtr(aRef.iPtr)
  {
    CleanupStack::PushL(TCleanupItem(CloseHBufC8Indirect, (void*)&iPtr));
  }


  template <class Y> operator auto_ptr_ref<Y>() 
    { return auto_ptr_ref<Y>(this->release()); }
  
private:
  HBufC8* iPtr;  
};

#endif // __auto_set_to_zero_H__
