#ifndef __REFCOUNTED_PTR_H__
#define __REFCOUNTED_PTR_H__  

#include <e32std.h>
#include <e32base.h>

class MRefCounted {
public:
	virtual void AddRef() const = 0;
	virtual void Release() const = 0;
};

IMPORT_C void CloseRefCountedIndirect(TAny* aPtr);

template<class Y> struct refcounted_ptr_ref
{
  Y* iPtr;
  refcounted_ptr_ref(Y* aPtr) : iPtr(aPtr) {}
};


template<class X> class refcounted_ptr
{
public:  
  typedef X element_type;

  refcounted_ptr(X* aPtr = 0): iPtr(aPtr), iBasePtr(aPtr)
  {
    CleanupStack::PushL(TCleanupItem(CloseRefCountedIndirect, (void*)&iBasePtr));
  }  
  
  refcounted_ptr(refcounted_ptr& aPtr): iPtr(aPtr.release()), iBasePtr(iPtr)
  {
    CleanupStack::PushL(TCleanupItem(CloseRefCountedIndirect, (void*)&iBasePtr));
  }

  refcounted_ptr<X>& operator=(refcounted_ptr<X>& aRhs)
  {
    if (&aRhs != this)
    {
      if (iBasePtr) iBasePtr->Release();
      iBasePtr = iPtr = aRhs.get();
      if(iBasePtr) iBasePtr->AddRef();
    }
    return (*this); 
  }

  ~refcounted_ptr() 
  { 
    CleanupStack::Pop();
    if (iBasePtr) iBasePtr->Release();
  }

  X& operator *() const { return *iPtr; }
  X* operator ->() const { return iPtr; }
   
  X* get() const { return iPtr; }

  X* release()
 	{ 
    X* result = iPtr;
    iBasePtr = iPtr = 0;
		return result; 
  }

  void reset(X* aPtr = 0) {
    if (aPtr != iPtr) {
      if (iBasePtr) iBasePtr->Release();
      iBasePtr = iPtr = aPtr;
    }
  }


  refcounted_ptr(refcounted_ptr_ref<X> aRef): iPtr(aRef.iPtr), iBasePtr(iPtr)
  {
    CleanupStack::PushL(TCleanupItem(CloseRefCountedIndirect, (void*)&iBasePtr));
  }


  template <class Y> operator refcounted_ptr_ref<Y>() 
    { return refcounted_ptr_ref<Y>(iPtr); }
  
private:
  X* iPtr;  
  MRefCounted* iBasePtr;
};

#endif
