/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CC_TIMEOUT_H_INCLUDED
#define CC_TIMEOUT_H_INCLUDED 1

#include <e32base.h>

class MTimeOut {
public:
	virtual void expired(CBase* Source) = 0;
};

class CTimeOut: public CTimer {
public:
	CTimeOut();
	virtual ~CTimeOut();
	IMPORT_C static CTimeOut* NewL(MTimeOut& i_cb);
	virtual void Wait(int seconds) = 0;
	virtual void WaitMax(int seconds) = 0; 
	// waits for max(given seconds, existing timeout)
	virtual void Reset() = 0;
};

IMPORT_C void SetTime();

#endif
