// 
// NTP connection for symbian by draven <riksa@medialab.sonera.fi>
// Do what ever you wish with these...
//
#include "NTPConnection.h"


EXPORT_C CNTPConnection* CNTPConnection::NewL(MSocketObserver& aObserver) 
{
	CNTPConnection* self=new (ELeave) CNTPConnection(aObserver); 
	CleanupStack::PushL(self);
	self->ConstructL(); 
	CleanupStack::Pop();
	return self;
};

CNTPConnection::CNTPConnection(MSocketObserver& aObserver) : 
	CActive( EPriorityNormal ), iReplyPtr( iReply, 1024, 1024 ), iState(0),
		iObserver(aObserver)  { }
void CNTPConnection::ConstructL()
{

	TInt ret=iSocketServ.Connect();
	if (ret!=KErrNone)
	{
		iSocketServ.Close();
		iObserver.info(this, _L("NTP Connection: Connecting to SocketServ failed."));
		return;
	}

	iTimeOutTimer=CPeriodic::NewL(EPriorityHigh);
	CActiveScheduler::Add( this );

//	SetHost( INET_ADDR(131,188,3,220), 123 ); // default
	SetHost( INET_ADDR(130,149,17,8), 123 ); // default
	
}

EXPORT_C CNTPConnection::~CNTPConnection()
{
	Cancel();
	iSocketServ.Close();

    StopTimeoutTimer();
    delete iTimeOutTimer;
}


EXPORT_C void CNTPConnection::SetHost( TUint32 anAddr, TUint aPort )
{
	NTPHost.SetAddress( anAddr );
	NTPHost.SetPort( aPort );
}


TInt CNTPConnection::TimeOutCallBack(TAny* aPtr)
{
	CNTPConnection* that = (CNTPConnection*) aPtr;
	that->StopTimeoutTimer();
	that->iSocket.CancelAll();

	return 0;	
}

void CNTPConnection::StartTimeoutTimer()
{
	if( !iTimeOutTimer->IsActive() )
	    iTimeOutTimer->Start(2000*1000, 10000*1000, TCallBack(TimeOutCallBack,this));
}

void CNTPConnection::StopTimeoutTimer()
{
	if( iTimeOutTimer->IsActive() )
		iTimeOutTimer->Cancel();
}

void CNTPConnection::DoCancel()
{
}

EXPORT_C void CNTPConnection::Sync()
{
	if ( iState != 0 ) return;

/*
	TIME1970 = 2208988800L      # Thanks to F.Lundh
	client = socket.socket( socket.AF_INET, socket.SOCK_DGRAM )
	data = '\x1b' + 47 * '\0'
	client.sendto( data, ( sys.argv[1], 123 ))
	data, address = client.recvfrom( 1024 )
	if data:
	    print 'Response received from:', address
	    t = struct.unpack( '!12I', data )[10]
	    t -= TIME1970
	    print '\tTime=%s' % time.ctime(t)
*/
//+The timestamp in the NTP packet is a 32bit integer which represents
//+the number of seconds after 00:00 01/01/1900. This 32bit number will
	// Open channel to Socket Server

	// Open a UDP socket
	int ret=iSocket.Open(iSocketServ, KAfInet, KSockDatagram, KProtocolInetUdp) ;
	if (ret!=KErrNone)
	{
		iSocketServ.Close();
		iObserver.info(this, _L("NTP Connection: Opening socket failed."));		
		return;
	}
	
	TUint8 data[48];
	for( int i = 0 ; i < 48 ; i++) data[i] = 0;
/*    http://www.faqs.org/rfcs/rfc2030.html
      LI       Value     Meaning
      -------------------------------------------------------
      00       0         no warning
      01       1         last minute has 61 seconds
      10       2         last minute has 59 seconds)
      11       3         alarm condition (clock not synchronized)


   Version Number (VN): This is a three-bit integer indicating the
   NTP/SNTP version number. The version number is 3 for Version 3 (IPv4
   only) and 4 for Version 4 (IPv4, IPv6 and OSI). If necessary to
   distinguish between IPv4, IPv6 and OSI, the encapsulating context
   must be inspected.


   Mode: This is a three-bit integer indicating the mode, with values
   defined as follows:
      Mode     Meaning
      ------------------------------------
      0        reserved
      1        symmetric active
      2        symmetric passive
      3        client
      4        server
      5        broadcast
      6        reserved for NTP control message
      7        reserved for private use
      */
	data[0] = 0x0b; // LLVVVMMM Leap=0, V=3, M=3  00011011

	TPtr8 dataPtr( data, 48, 48 );
	
	iSocket.SendTo( dataPtr , NTPHost , 0, iStatus );
	SetActive();
	iState = 1;

	return;
}

void CNTPConnection::RunL()
{
	StopTimeoutTimer();

	if( iStatus != KErrNone )
	{
		iObserver.info(this, _L("NTP Connection: Server timed out") );
		iState = 0;
	}
	else
	{
		if( iState == 1 )
		{
			for( int i = 0 ; i < 1024 ; i++) iReply[i] = 0;
			iSocket.RecvFrom( iReplyPtr, iReplyAddr, 0,  iStatus );
			SetActive();
			StartTimeoutTimer();
			iState = 2;
		}
		else
		{
			iState = 0;
//	                           1                   2                   3
//	       0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
//	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
//	      |LI | VN  |Mode |    Stratum    |     Poll      |   Precision   |
//	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
//	      |                          Root Delay                           |
//	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
//	      |                       Root Dispersion                         |
//	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
//	      |                     Reference Identifier                      |
//	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
//	      |                                                               |
//	      |                   Reference Timestamp (64)                    |
//	      |                                                               |
//	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
//	      |                                                               |
//	      |                   Originate Timestamp (64)                    |
//	      |                                                               |
//	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
//	      |                                                               |
//	      |                    Receive Timestamp (64)                     |
//	      |                                                               |
//	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
//	      |                                                               |
//	      |                    Transmit Timestamp (64)                    |
//	      |                                                               |
//	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
//	      |                 Key Identifier (optional) (32)                |
//	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
//	      |                                                               |
//	      |                                                               |
//	      |                 Message Digest (optional) (128)               |
//	      |                                                               |
//	      |                                                               |
//	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
//	
//	
//	   Reference Timestamp: This is the time at which the local clock was
//	   last set or corrected, in 64-bit timestamp format.
//	   Originate Timestamp: This is the time at which the request departed
//	   the client for the server, in 64-bit timestamp format.
//	   Receive Timestamp: This is the time at which the request arrived at
//	   the server, in 64-bit timestamp format.
//	   Transmit Timestamp: This is the time at which the reply departed the
//	   server for the client, in 64-bit timestamp format.
//
			TUint seconds   = 0;
			TUint fractions = 0;
			seconds   = (iReply[40]<<24) | (iReply[41]<<16) | (iReply[42]<<8) | (iReply[43]<<0);
			fractions = (iReply[44]<<24) | (iReply[45]<<16) | (iReply[46]<<8) | (iReply[47]<<0);
		
			TInt64 microseconds = seconds;
			microseconds *= (1000 * 1000);
			TInt64 foo = fractions;
			foo *= 1000*1000;
			foo /= 0xffffffff;
			microseconds += foo;
		
			TTime currentTime;
			currentTime.HomeTime();
			
			TTime correctTime( _L("19000000:") );
			correctTime += TTimeIntervalMicroSeconds( microseconds );
		
		    TLocale locale;
		    TTimeIntervalSeconds universalTimeOffset(locale.UniversalTimeOffset());
		    correctTime+=universalTimeOffset;
		    if( locale.QueryHomeHasDaylightSavingOn() )
		    {
		        correctTime += TTimeIntervalHours(1);
		    }
			User::SetHomeTime( correctTime );
		
		    _LIT(KTimeString,"%1/%2/%3 %-B%:0%J%:1%T%:2%S%.%*C4%:3%+B");
		    TBuf<32> timeString1;
		    TBuf<32> timeString2;
		    currentTime.FormatL(timeString1,KTimeString);
		    correctTime.FormatL(timeString2,KTimeString);
		
			TBuf<1100> buf;
			buf.Copy(_L( "Current time: " ) );
			buf.Append( timeString1 );
			buf.Append( _L("\n") );
		
			buf.Append(_L( "Correct time: " ) );
			buf.Append( timeString2 );
			buf.Append( _L("\n") );
		
			iObserver.info(this, buf );
		}
	}
}


