/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 

*/


#include "checkedactive.h"
#include "app_context.h"
#include "app_context_impl.h"
#include "reporting.h"
#include "callstack.h"

EXPORT_C CCheckedActive::~CCheckedActive()
{
	if (iContext) {
		if (iRunLCount>0) {
			TBuf<120> stats=_L("STATS for ");
			stats.Append(iName);
			stats.Append(_L(" n: ")); stats.AppendNum(iRunLCount);
			stats.Append(_L(" min: ")); stats.AppendNum(iMinTicks);
			stats.Append(_L(" max: ")); stats.AppendNum(iMaxTicks);
			stats.Append(_L(" avg: ")); 
			stats.AppendNum(iTotalTicks/iRunLCount);
			stats.Append(_L(" var: ")); stats.AppendNum( 
				(iTotalSquaredTicks-(iTotalTicks*iTotalTicks)/iRunLCount)/iRunLCount
			);
			iContext->Reporting().DebugLog(stats);
		}
	}
	delete iLatestErrorStack;
	if (iLive) *iLive=0;
	iLive=0;
}

EXPORT_C CCheckedActive::CCheckedActive(TInt aPriority, const TDesC& Name) : CActive(aPriority)
{
	iContext=MApp_context::Static();
	/*
	if (iContext) {
		TBuf<65> creation;
		creation=_L("created ");
		creation.Append(Name.Left(40));
		creation.Append(_L(" at "));
		creation.AppendNum( (TUint)( (CActive*)this ), EHex);
		iContext->DebugLog(creation);
	}
	*/
	iName=Name.Left(40);
}

EXPORT_C TInt CCheckedActive::RunError(TInt aError)
{
	TInt ret=CheckedRunError(aError);
	
	if (ret!=KErrNone) {
		MApp_context* c=iContext;
		if (c) {
			HBufC* stack=0;
			stack=c->CallStackMgr().GetFormattedCallStack(iName);
			if (stack) {
				CleanupStack::PushL(stack);
				c->ReportActiveError(*stack,
					_L("Active Object Run Error"), ret);
				// don't reset stack here so that the stack
				// can be seen from where the error gets
				// propagated to
				// c->ResetCallStack();
				CleanupStack::PopAndDestroy(); // stack
			} else {
				c->ReportActiveError(iName,
					_L("Active Object Run Error"), ret);
			}
		}
	}
	return ret;
}

EXPORT_C void CCheckedActive::SetActive()
{
#ifdef __WINS__
	// this code is there so that we can set a
	// breakpoint if suspecting a misuse
	// of iStatus and SetActive()
	if (iStatus!=KRequestPending) {
		TInt x;
		x=1;
	}
#endif
	CActive::SetActive();
}

EXPORT_C TInt CCheckedActive::CheckedRunError(TInt aError)
{
	return aError;
}

EXPORT_C void CCheckedActive::RunL()
{
#ifdef __WINS__1
	RDebug::Print(_L("CCheckedActive::RunL"));
	RDebug::Print(iName);
#endif
	MApp_context* c=iContext;
	if (c) {
		c->CallStackMgr().ResetCallStack();
	}

	TInt live=1;
	iLive=&live;
	TUint start, stop;
	start=User::TickCount();

	TRAPD(err, CheckedRunL());
	if (live && c) {
		stop=User::TickCount();
		TUint elapsed=stop-start;
		if (elapsed > iMaxTicks || iRunLCount==0) iMaxTicks=elapsed;
		if (elapsed < iMinTicks || iRunLCount==0) iMinTicks=elapsed;
		++iRunLCount;
		iTotalTicks+=elapsed;
		iTotalSquaredTicks+=elapsed*elapsed;
	}
	iLive=0;

	if (err!=KErrNone) {
		delete iLatestErrorStack; iLatestErrorStack=0;
		iLatestErrorStack=c->CallStackMgr().GetFormattedCallStack(iName);
		User::Leave(err);
	}
}

EXPORT_C const TDesC& CCheckedActive::Name()
{
	return iName;
}