#include "errorhandling.h"
#include "app_context.h"
#include "vararg_impl_macros.h"
#include "app_context_impl.h"

IMPL_VARARG(MErrorInfoManager, UserMsg, MErrorInfoManager&, const TStringArg&);
IMPL_VARARG(MErrorInfoManager, TechMsg, MErrorInfoManager&, const TStringArg&);

_LIT(KNoAppContext, "NO_APP_CONTEXT");

MApp_context& Context()
{
	MApp_context* c=GetContext();
	if (!c) User::Panic(KNoAppContext, -1);
	return *c;
}

EXPORT_C MErrorInfoManager& Bug(const TDesC& aTechMsg)
{
	MErrorInfoManager &m=Context().ErrorInfoMgr();
	m.StartErrorWithInfo( KErrorBug, KNullDesC(),
		aTechMsg, EBug, EError );
	return m;
}

EXPORT_C MErrorInfoManager& Corrupt(const TDesC& aTechMsg)
{
	MErrorInfoManager &m=Context().ErrorInfoMgr();
	m.StartErrorWithInfo( KErrorUnknown, KNullDesC(),
		aTechMsg, EBug, ECorrupt );
	return m;
}
EXPORT_C MErrorInfoManager& InputErr(const TDesC& aUserMsg)
{
	MErrorInfoManager &m=Context().ErrorInfoMgr();
	m.StartErrorWithInfo( KErrorUnknown, aUserMsg,
		KNullDesC(), EInputData, EError );
	return m;
}
EXPORT_C MErrorInfoManager& RemoteErr(const TDesC& aTechMsg)
{
	MErrorInfoManager &m=Context().ErrorInfoMgr();
	m.StartErrorWithInfo( KErrorUnknown, KNullDesC(),
		aTechMsg, ERemote, EError );
	return m;
}
EXPORT_C MErrorInfoManager& EnvErr(const TDesC& aUserMsg)
{
	MErrorInfoManager &m=Context().ErrorInfoMgr();
	m.StartErrorWithInfo( KErrorUnknown, aUserMsg,
		KNullDesC(), ELocalEnvironment, EError );
	return m;
}

EXPORT_C MErrorInfoManager& PlainErr(TInt aError)
{
	MErrorInfoManager &m=Context().ErrorInfoMgr();
	TErrorCode e={ 0, aError };
	TErrorType t=EBug;
	if (aError==KErrNoMemory) t=ELocalEnvironment;
	m.StartErrorWithInfo( e, KNullDesC(),
		KNullDesC(), t, EError );
	return m;
}