#include "icons.h"

#include <eikenv.h> 
#include <contextcommon.mbg>
#include <bautils.h>
#include <avkon.mbg>
#include <s32file.h>
#include <gulicon.h>
#include "app_context.h"

#define _INIT_T_ICON_ID(txt,val1,val2) { L##txt, val1, val2}

const TInt KNbIcons=47;

_LIT(KMbmAvkon, "Z:\\system\\data\\avkon.mbm");
#ifndef __WINS__
_LIT(KMbmBook,  "Z:\\system\\data\\contextcommon.mbm");
#else
_LIT(KMbmBook,  "C:\\system\\data\\contextcommon.mbm");
#endif

static const TIconID iconId[KNbIcons]=
{
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_stat_bt_blank, EMbmAvkonQgn_stat_bt_blank +1),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_address, EMbmAvkonQgn_prop_nrtyp_address_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_email, EMbmAvkonQgn_prop_nrtyp_email_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_fax, EMbmAvkonQgn_prop_nrtyp_fax_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_home, EMbmAvkonQgn_prop_nrtyp_home_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_mobile, EMbmAvkonQgn_prop_nrtyp_mobile_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_note, EMbmAvkonQgn_prop_nrtyp_note_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_pager, EMbmAvkonQgn_prop_nrtyp_pager_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_phone, EMbmAvkonQgn_prop_nrtyp_phone_mask ),

/*10*/  _INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_url, EMbmAvkonQgn_prop_nrtyp_url_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_work, EMbmAvkonQgn_prop_nrtyp_work_mask ),
	
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_indi_marked_add, EMbmAvkonQgn_indi_marked_add_mask),
	#ifndef __WINS__

	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_on, EMbmContextcommonSpeaker_on_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_on_grey, EMbmContextcommonSpeaker_on_grey_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_off, EMbmContextcommonSpeaker_off_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_off_grey, EMbmContextcommonSpeaker_off_grey_mask ),
	
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_on, EMbmContextcommonVibrator_on_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_on_grey, EMbmContextcommonVibrator_on_grey_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_off, EMbmContextcommonVibrator_off_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_off_grey, EMbmContextcommonVibrator_off_grey_mask ),

/*20*/	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_active, EMbmContextcommonUser_active_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_1, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_2, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_3, EMbmContextcommonUser_inactive_mask ),

	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy1, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy2, EMbmContextcommonBuddy2_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy3, EMbmContextcommonBuddy3_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy4, EMbmContextcommonBuddy4_mask ),

	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy1_grey, EMbmContextcommonBuddy1_mask ),
/*30*/	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy2_grey, EMbmContextcommonBuddy2_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy3_grey, EMbmContextcommonBuddy3_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy4_grey, EMbmContextcommonBuddy4_mask ),

	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther1, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther2, EMbmContextcommonBuddy2_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther3, EMbmContextcommonBuddy3_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther4, EMbmContextcommonBuddy4_mask ),

	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther1_grey, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther2_grey, EMbmContextcommonBuddy2_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther3_grey, EMbmContextcommonBuddy3_mask ),
/*40*/	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther4_grey, EMbmContextcommonBuddy4_mask ),

	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonDesktop, EMbmContextcommonDesktop_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonDesktop_grey, EMbmContextcommonDesktop_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonLaptop, EMbmContextcommonLaptop_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonLaptop_grey, EMbmContextcommonLaptop_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonPda, EMbmContextcommonPda_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonPda_grey, EMbmContextcommonPda_mask ),
	#else

	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_on, EMbmContextcommonSpeaker_on_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_on_grey, EMbmContextcommonSpeaker_on_grey_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_off, EMbmContextcommonSpeaker_off_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_off_grey, EMbmContextcommonSpeaker_off_grey_mask ),
	
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_on, EMbmContextcommonVibrator_on_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_on_grey, EMbmContextcommonVibrator_on_grey_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_off, EMbmContextcommonVibrator_off_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_off_grey, EMbmContextcommonVibrator_off_grey_mask ),

	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_active, EMbmContextcommonUser_active_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_1, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_2, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_3, EMbmContextcommonUser_inactive_mask ),

	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy1, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy2, EMbmContextcommonBuddy2_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy3, EMbmContextcommonBuddy3_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy4, EMbmContextcommonBuddy4_mask ),

	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy1_grey, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy2_grey, EMbmContextcommonBuddy2_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy3_grey, EMbmContextcommonBuddy3_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy4_grey, EMbmContextcommonBuddy4_mask ),

	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther1, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther2, EMbmContextcommonBuddy2_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther3, EMbmContextcommonBuddy3_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther4, EMbmContextcommonBuddy4_mask ),

	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther1_grey, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther2_grey, EMbmContextcommonBuddy2_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther3_grey, EMbmContextcommonBuddy3_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther4_grey, EMbmContextcommonBuddy4_mask ),

	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonDesktop, EMbmContextcommonDesktop_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonDesktop_grey, EMbmContextcommonDesktop_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonLaptop, EMbmContextcommonLaptop_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonLaptop_grey, EMbmContextcommonLaptop_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonPda, EMbmContextcommonPda_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonPda_grey, EMbmContextcommonPda_mask ),
	#endif
};

EXPORT_C TInt GetIconBitmap(TInt index)
{
	return iconId[index].iBitmap;
}

EXPORT_C TInt GetIconMask(TInt index)
{
	return iconId[index].iMask;
}


EXPORT_C TPtrC GetIconMbm(TInt index)
{
	return TPtrC((TText16*)iconId[index].iMbmFile);
}

void GetIconInfo(const TDesC& FileName, RFs& Fs, RFile& File, RFileReadStream& s, RArray<TInt>& Offsets, int round)
{
	TBuf<50> c=_L("GetIconInfo round "); c.AppendNum(round);

	TInt table_offset=0;
	{

		User::LeaveIfError(File.Open(Fs, FileName, EFileRead|EFileShareAny));
		RFile f0=File;
		s.Attach(f0, 0); 
		TInt uid=s.ReadUint32L();
		TUid file_uid={ uid };
		if (file_uid==KMultiBitmapRomImageUid) {
			table_offset=0x4;
		} else {
			uid=s.ReadUint32L(); // uid2
			uid=s.ReadUint32L(); // uid3
			uid=s.ReadUint32L(); // uid4 == checksum
			table_offset=s.ReadUint32L();
		}
	}

	TInt size=0; 
	{
		c=_L("GetIconInfo::2::"); c.AppendNum(table_offset);
		RFile f=File;
		s.Attach(f, table_offset);
		size=s.ReadUint32L();
		Offsets.Reset();
	}

/*
	MApp_context* ctx=GetContext();
	c=_L("offset::"); c.AppendNum(table_offset); c.Append(_L(" ")); 
	c.Append(_L("size::")); c.AppendNum(size); c.Append(_L(" i::0"));
*/
	int i=0;
	for (i=0; i<size; i++) {
		TInt offset=s.ReadUint32L();
		User::LeaveIfError(Offsets.Append(offset));
/*
		c=_L("offset::"); c.AppendNum(table_offset); c.Append(_L(" ")); 
		c.Append(_L("size::")); c.AppendNum(size); c.Append(_L(" i::")); c.AppendNum(i);
*/
	}
}

EXPORT_C void LoadIcons(CAknIconArray * aIconList)
{
	CALLSTACKITEM_N(_CL("User"), _CL("LeaveIfError"));

	TFileName real; TFileName prev;
	CEikonEnv* env=CEikonEnv::Static();
	RFs& fs=env->FsSession();
	CWsScreenDevice* screen=env->ScreenDevice();
	RWsSession& ws=env->WsSession();
	RArray<TInt> Offsets; RFile File; bool file_is_open=false;
	CleanupClosePushL(Offsets);
	RFileReadStream s;
	int j=0;

	bool romfile=false;
	for (int i = 0; i<KNbIcons;i++)
	{
		TPtrC file((TText16*)iconId[i].iMbmFile);
		if (prev.Compare(file)) {
			real=file;
			if (! BaflUtils::FileExists(fs, real)) {
				real.Replace(0, 1, _L("e"));
			}
			prev=file;
			if (file_is_open) {
				s.Close();
				file_is_open=false;
			}
			if (real.Left(1).CompareF(_L("z"))==0) {
				romfile=true;
			} else {
				romfile=false;
				GetIconInfo(real, fs, File, s, Offsets, j);
				file_is_open=true;
			}
			++j;
		}

		CWsBitmap* bitmap=new (ELeave) CWsBitmap(ws);
		CleanupStack::PushL(bitmap);
		if (!romfile) {
			RFile f1=File;
			s.Attach(f1, Offsets[iconId[i].iBitmap]);	
			bitmap->InternalizeL(s);
		} else {
			User::LeaveIfError(bitmap->Load(real, iconId[i].iBitmap));
		}
		bitmap->SetSizeInTwips(screen);

		CWsBitmap* mask=new (ELeave) CWsBitmap(ws);
		CleanupStack::PushL(mask);
		if (!romfile) {
			RFile f2=File;
			s.Attach(f2, Offsets[iconId[i].iMask]);
			mask->InternalizeL(s);
		} else {
			User::LeaveIfError(mask->Load(real, iconId[i].iMask));
		}
		mask->SetSizeInTwips(screen);

		CGulIcon *icon=CGulIcon::NewL(bitmap, mask);
		CleanupStack::Pop(2);  // bitmap, mask
		CleanupStack::PushL(icon);
		aIconList->AppendL(icon);
		CleanupStack::Pop(); // icon
	}
	if (file_is_open) {
		s.Close();
	}
	CleanupStack::PopAndDestroy(); // Offsets
}

EXPORT_C TInt GetIconIndex(TInt identifier)
{
	for (int i = 0; i<KNbIcons;i++)
	{
		if ( iconId[i].iBitmap == identifier )
		{
			return i;
		}
	}	
	return 0; // index of empty icon
}