/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/

/*
 * Concepts:
 * !Threading!
 */

#include "independent.h"
#include "symbian_auto_ptr.h"
#include <e32svr.h>

class CThreadNotify : public CActive {
public:
	static CThreadNotify*	NewL(worker_info* info) {
		auto_ptr<CThreadNotify> ret(new (ELeave) CThreadNotify(info));
		ret->ConstructL();
		return ret.release();
	}
	~CThreadNotify() {
		Cancel();
		iThread.Close();
	}	
	void StartL() {
		User::LeaveIfError(iThread.Open(iInfo->worker_threadid));
		iThread.Logon(iStatus);
		SetActive();
	}

private:
	worker_info*	iInfo;
	RThread		iThread;

	CThreadNotify(worker_info* aInfo) : CActive(EPriorityLow), iInfo(aInfo) { }
	void ConstructL() {
		CActiveScheduler::Add(this);
	}
	void RunL() {
		TInt err=KErrNone;
		iInfo->exit_type=iThread.ExitType();
		iInfo->exit_reason=iThread.ExitReason();
		iInfo->exit_cat=iThread.ExitCategory();
		err=iStatus.Int();
		if (*iInfo->is_stopped == KRequestPending) {
			TRequestStatus *s=iInfo->is_stopped;
			User::RequestComplete(s, err);
		}
	}
	void DoCancel() {
		iThread.LogonCancel(iStatus);
	}

};

EXPORT_C worker_info::worker_info()
{
	do_stop=&i_do_stop;
	is_stopped=&i_is_stopped;
	*do_stop=KRequestPending;
	*is_stopped=KRequestPending;
}

EXPORT_C worker_info::~worker_info()
{
}

EXPORT_C bool worker_info::stop_requested()
{
	if (*do_stop!=KRequestPending) return true;
	return false;
}

EXPORT_C void worker_info::set_do_stop(TRequestStatus* s)
{
	// FIXME: race condition
	do_stop=s;
	*do_stop=KRequestPending;
}

EXPORT_C void worker_info::set_has_stopped(TRequestStatus* s)
{
	is_stopped=s;
	*is_stopped=KRequestPending;
}

EXPORT_C void worker_info::please_stop()
{
	is_stopped=&i_is_stopped;
	*is_stopped=KRequestPending;
	RThread t;
	t.Open(worker_threadid);
	TRequestStatus* s;
	s=do_stop;
	t.RequestComplete(s, 1);
	t.Close();
}

EXPORT_C void worker_info::stopped(TInt aCode)
{
	/*
	TRequestStatus* s=is_stopped;
	if (*s != KRequestPending) return;
	RThread t;
	t.Open(parent_threadid);
	t.RequestComplete(s, aCode);
	t.Close();
	*/
}

EXPORT_C void worker_info::wait_for_stop()
{
	if (is_stopped->Int()==KRequestPending) {
		RThread t;
		if (t.Open(worker_threadid)!=KErrNone) return;
		TRequestStatus s;
		t.Logon(s);
		if (t.ExitType()!=EExitPending) {
			t.LogonCancel(s);
			t.Close();
			return;
		}
		User::WaitForRequest(s);
		t.Close();
	}
}

EXPORT_C void independent_worker::start(const TDesC& name, TThreadFunction aFunction, TAny* worker_args,
					TThreadPriority aPriority)
{
	delete iThreadNotify; iThreadNotify=0;
	info.exit_type=EExitPending;
	iThreadNotify=CThreadNotify::NewL(&info);
	RThread t; RThread me;
	info.parent_threadid=me.Id();
	info.worker_args=worker_args;
	t.Create(name, aFunction, 8192, 4096, 1024*1024, (TAny*) &info);
	info.worker_threadid=t.Id(),
        t.SetPriority(aPriority);
	//TInt err=RDebug::SetBreakPoint(t.Id(), (TUint)aFunction);
        t.Resume();
	t.Close();
	iThreadNotify->StartL();
	is_started=true;
}

EXPORT_C void independent_worker::stop()
{
	delete iThreadNotify; iThreadNotify=0;

	if (!is_started) return;
	if (info.exit_type!=EExitPending) return;

	info.please_stop();

	TTimeIntervalMicroSeconds32 w(50*1000);
	User::After(w);

	info.wait_for_stop();
	is_started=false;
}

EXPORT_C independent_worker::~independent_worker()
{
	stop();
}
	
EXPORT_C independent_worker::independent_worker()
{
	is_started=false;
}
