#include "reporting.h"
#include <e32std.h>

void StopBusy(TAny* aPtr) {
	TAutoBusy* a=(TAutoBusy*)aPtr;
	a->iReporting.ShowBusy(a->iPreviousBusy);
}

EXPORT_C TAutoBusy::TAutoBusy(MReporting& aReporting) : iReporting(aReporting)
{
	CleanupStack::PushL(TCleanupItem(StopBusy, (void*)this));
	iPreviousBusy=aReporting.ShowBusy(ETrue);
}

EXPORT_C TAutoBusy::~TAutoBusy()
{
	iReporting.ShowBusy(iPreviousBusy);
	CleanupStack::Pop();
}
