#include "stringarg.h"

_LIT(KTruncated, "[trunc]...");

EXPORT_C void TStringArg::AppendToString(TDes& aString) const
{
	if (aString.MaxLength()-aString.Length() >= Length() ) {
		DoAppendToString(aString);
	} else {
		aString.Append(KTruncated().Right(aString.MaxLength()-aString.Length()));
	}
}

_LIT(KSpace, " ");

EXPORT_C void TStringArg::DoAppendToString(TDes& aString) const
{
	switch (iType) {
	case EInt:
		aString.AppendNum(iVal.iInt);
		break;
	case EUint:
		aString.AppendNum(iVal.iUint);
		break;
	case EDes:
		aString.Append(*(iVal.iDes));
		break;
	case EChar:
		aString.Append(TPtrC(iVal.iChar));
		break;
	case ECharArr:
		{
			const TText16* c=iVal.iCharArr[0];
			while (c) {
				aString.Append(TPtrC(c));
				aString.Append(KSpace);
				c++;
			}
		}
		break;
	case ECustom:
		(*iCustomAppend)(iVal.iCustom, aString);
	}
}

EXPORT_C TUint TStringArg::Length() const
{
	switch (iType) {
	case EInt:
	case EUint:
		return 12;
	case EDes:
		return iVal.iDes->Length();
	case EChar:
		return TPtrC(iVal.iChar).Length();
	case ECharArr:
		{
			TInt len=0;
			const TText16* c=iVal.iCharArr[0];
			while (c) {
				len+=TPtrC(c).Length();
				len+=1;
				c++;
			}
			return len;
		}
	case ECustom:
		return iCustomLen;
	}
	return 0;
}

EXPORT_C TStringArg::TStringArg(TInt aArg) : iType(EInt) { iVal.iInt=aArg; }

EXPORT_C TStringArg::TStringArg(TUint aArg) : iType(EUint) { iVal.iUint=aArg; }

EXPORT_C TStringArg::TStringArg(const TDesC& aArg) : iType(EDes)  { iVal.iDes=&aArg; }

EXPORT_C TStringArg::TStringArg() : iType(ECustom) { }

EXPORT_C TStringArg::TStringArg(const XML_Char* aChar) : iType(EChar) { iVal.iChar=(TText16*)aChar; }
EXPORT_C TStringArg::TStringArg(const XML_Char** aCharArr) : iType(ECharArr) { iVal.iCharArr=(const TText16**)aCharArr; }

EXPORT_C TStringArg::TStringArg(const void* aCustomData, TInt aLength, 
				void(*aCustomAppend)(const void* aData, TDes& aString)) : iType(ECustom), 
				iCustomLen(aLength), iCustomAppend(aCustomAppend)
{
	iVal.iCustom=aCustomData;
}
