/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/

#ifndef CB_PRESENCE_H_INCLUDED
#define CB_PRESENCE_H_INCLUDED 1

#include "symbian_tree.h"
#include "list.h"
#include "jabberdata.h"
#include "csd_presence.h"
#include "contextclientsession.h"
#include "timeout.h"


class MPresenceListener {
public:
	virtual void PresenceChangedL(TInt ContactId, CBBPresence* Info) = 0;
	virtual void Notify(const TDesC & aMessage) = 0;
};

class CPresenceHolder : public CCheckedActive, public MTimeOut {
public:
	IMPORT_C static CPresenceHolder* NewL(CJabberData& JabberData);
	IMPORT_C ~CPresenceHolder();

	IMPORT_C void AddListener(MPresenceListener* Listener);
	IMPORT_C const CBBPresence* const GetPresence(TInt ContactId) const;

	IMPORT_C void CancelRequest();
	IMPORT_C void NewPresence(const TDesC& Nick, const TDesC& Info, const TTime& send_timestamp);
	IMPORT_C CBBPresence* GetPresence(TInt ContactId);

private: // from CCheckedActive
	void CheckedRunL();
	void DoCancel();

private:
	CPresenceHolder(CJabberData& JabberData);
	void ConstructL();

	static void CBBPresenceDeletor(void* p);

	CJabberData&			iJabberData;
	CGenericIntMap*			iPresenceData;
	CList<MPresenceListener*>*	iListeners;

private:
	void Start();
	void Restart();
	void expired(CBase*);
	void RequestPresence();
	void RequestPresenceNotification();

	

	enum TState
	{
      		EIdle,
        	EWaitingForPresence		
	};

	TState current_state;

	RContextClientSession  		iSession;
	
	HBufC * 			iContact;
	HBufC *				iPresence;
	TPtr				iC;
	TPtr				iP;
	bool				iSessionOpen;
	CTimeOut*			iWait;
	TTime				iSendTimeStamp;
	static const TInt KDefaultBufferSize;

};

#endif
