/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CB_PHONEBOOK_H_INCLUDED
#define CB_PHONEBOOK_H_INCLUDED 1

#include <e32base.h>
#include <badesca.h>
#include <cntdef.h>
#include <cpbkcontactengine.h> 
#include <mpbkcontactdbobserver.h> 
#include <cpbkcontactchangenotifier.h> 
#include "db.h"
#include "symbian_tree.h"
#include "cb_presence.h"
#include "jabberdata.h"

class contact : public CBase 
{
public:
	TContactItemId	id;
	HBufC*		first_name;
	HBufC*		last_name;
	TInt		current_idx;
	bool		has_nick;
	CBBPresence* presence;
	IMPORT_C void Name(HBufC*& Into, bool last_name_first);
	contact() {
		id=0;
		first_name=0;
		last_name=0;
		presence=0;
		has_nick=false;
	}

	IMPORT_C static contact* NewL(TContactItemId i_id, const TDesC& i_first_name, const TDesC& i_last_name);
	IMPORT_C void set_presence(CBBPresence* data);
	IMPORT_C ~contact();
};

class phonebook_observer {
public:
	virtual void before_change() = 0;
	virtual void contents_changed() = 0;
	virtual void exiting() = 0;
};

class phonebook_i {
public:
	phonebook_i() { }
	virtual ~phonebook_i() { }
	virtual void ConstructL() = 0;
	virtual CPbkContactEngine* get_engine() = 0;
	
	virtual TInt Count() = 0;
	virtual void set_observer(phonebook_observer* i_obs) = 0;

	virtual bool filter(const TDesC& substr, bool force=false) = 0;
	virtual TInt GetContactId(TInt Index) = 0;
	virtual TInt GetIndex(TInt ContactId) = 0;
	virtual contact * GetContact(TInt index) = 0;
	virtual void ReRead() = 0;
};

class phonebook : public CBase, MPbkContactDbObserver, public phonebook_i, public MContextBase,
	public MPresenceListener {
public:
	IMPORT_C phonebook(MApp_context& Context, CJabberData * JabberData, CPresenceHolder * PresenceHolder);
	IMPORT_C virtual ~phonebook();
	IMPORT_C void ConstructL();

	//from phonebook_i
	IMPORT_C virtual TInt Count();
	IMPORT_C virtual TInt GetContactId(TInt Index);
	IMPORT_C virtual TInt GetIndex(TInt ContactId);

	
	IMPORT_C CPbkContactEngine* get_engine();
	IMPORT_C bool filter(const TDesC& substr, bool force=false);
	IMPORT_C virtual void set_observer(phonebook_observer* i_obs);
	IMPORT_C phonebook_observer * get_observer();

	
	IMPORT_C virtual void PresenceChangedL(TInt ContactId, CBBPresence* Info);
	IMPORT_C void Notify(const TDesC& aMessage);
	IMPORT_C virtual contact * GetContact(TInt index);
	IMPORT_C CArrayFixFlat<contact*>* GetContacts();

	IMPORT_C virtual void ReRead();

private:
	// MPbkContactDbObserver::
	void HandleDatabaseEventL(TContactDbObserverEvent aEvent); 

	void read_data(CPbkContactIter * iter);
	void read_db();
	void reset_contacts();
	
	CArrayFixFlat<contact*>* contacts;
	CArrayFixFlat<TContactItemId>* current_ids;
	
	CPbkContactEngine *eng;
	bool owns_engine;
	TBuf<20> previous_filter;
	phonebook_observer* obs;
	CPbkContactItem* contactitem; // used for getting phone no

	CPbkContactChangeNotifier* chnot;
	CGenericIntMap *iContactToIndex;
	CJabberData *	iJabberData;
	CPresenceHolder * iPresenceHolder;
};


class CPresenceUpdater : public MTimeOut, public CBase
{
public : 
	IMPORT_C static CPresenceUpdater * NewL(phonebook_i & book);
	IMPORT_C void ConstructL();
	IMPORT_C virtual ~CPresenceUpdater();
	IMPORT_C CPresenceUpdater(phonebook_i & book);


	IMPORT_C void Start();
	IMPORT_C void Stop();
	IMPORT_C void Refresh();

public : // MTimeOut
	void expired(CBase*);

private:
	phonebook_i & book;
	CTimeOut * iWait;
	TBool iWaiting;

	const static TInt KTimeOut;
};

#endif
