/*
* ============================================================================
*  Name     : CContextContactsAppUi from ContextContactsAppUi.h
*  Part of  : ContextContacts
*  Created  : 10/05/2004 by 
*  Description:
*     Declares UI class for application.
*  Version  :
*  Copyright: 
* ============================================================================
*/

#ifndef CONTEXTCONTACTSAPPUI_H
#define CONTEXTCONTACTSAPPUI_H

// INCLUDES
#include <eikapp.h>
#include <eikdoc.h>
#include <e32std.h>
#include <coeccntx.h>
#include <aknviewappui.h>
#include <akntabgrp.h>
#include <aknnavide.h>
#include <akniconarray.h>

#include "ContextContactsDetailView.h"
#include <file_output_base.h>
#include <app_context.h>
#include "phonebook.h"
#include "jabberdata.h"
#include "cb_presence.h"
#include <presencedetailview.h>
#include "contextcontactsview.h"
#include "contextcontactsview2.h"

class CContextContactsContainer;


class CContextContactsAppUi : public CAknViewAppUi, MCoeForegroundObserver, public MContextBase, public MPresenceListener, public MTimeOut
    {
    public: 
	CContextContactsAppUi (MApp_context& Context) : MContextBase(Context) { }
        void ConstructL();
        ~CContextContactsAppUi();
        
    public: // New functions
	void Notify(const TDesC& aMessage);
	void PresenceChangedL(TInt ContactId, CBBPresence* Data);
	void DisplayPresenceDetailsL(const TDesC& Name, const CBBPresence* Data);
	void DisplayPresenceDescriptionL(const TDesC& Name, const CBBPresence* Data);
    
    private:
	virtual void HandleGainingForeground();
	virtual void HandleLosingForeground();
	
    private:
        void HandleCommandL(TInt aCommand);
	virtual void ProcessMessageL(TUid aUid,const TDesC8& aParams);
	void HandleWsEventL(const TWsEvent& aEvent,CCoeControl* aDestination);
	void hide();
        virtual TKeyResponse HandleKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);

   private:

	typedef void (CContextContactsAppUi::*TCallBack)(void);
	CList<TCallBack> *iWaitingOps;
	CTimeOut	 *iWait;
	void QueueOp(TCallBack Op, int AfterSeconds=0);
	void expired(CBase*);


        CAknNavigationControlContainer* iNaviPane;
        CAknTabGroup*                   iTabGroup;
        CAknNavigationDecorator*        iDecoratedTabGroup;

	phonebook*	iBook;
	phonehelper *   iPhoneHelper;
	CDb*		iJabberDb;
	CJabberData*	iJabberData;

	CContextContactsView* iContactsView; // OWNED BY FRAMEWORK
	class CPresenceDetailView	*iPresenceDetailView; // OWNED BY FRAMEWORK
	class CPresenceDescriptionView	*iPresenceDescriptionView; // OWNED BY FRAMEWORK
	CContextContactsDetailView * iContactDetailView; // OWNED BY FRAMEWORK
	CContextContactsView2* iGroupsView; // OWNED BY FRAMEWORK
	//CSettingsView * iSettingsView; // OWNED BY FRAMEWORK

	CPresenceUpdater* iPresenceUpdater;
	CPresenceHolder* iPresenceHolder;

	Cfile_output_base * iLog;

	CAknIconArray * iIconlist;
	CArrayFixFlat<TInt>* iResource_files;
    };

#endif


