#ifndef CONTEXTCONTACTSCONTAINER_H
#define CONTEXTCONTACTSCONTAINER_H

#include <coecntrl.h>
#include <aknlists.h>
#include <cntitem.h>
#include <e32base.h>
#include <CPbkContactEngine.h>
#include <eikedwin.h>
#include <sendui.h>
#include <aknsfld.h> 
#include <aknglobalnote.h>
#include <cpbkcontactengine.h> 
#include <akniconarray.h>

#include "doublelinebox.h"
#include "phonehelper.h"
#include "phonebook.h"

#include "file_output_base.h"
#include "icons.h"
#include <AknView.h>

class CContextContactsContainer : public CCoeControl, public MCoeControlObserver, public MEikListBoxObserver, public phonebook_observer, public MContextBase
{
    public: 
        void ConstructL(const TRect& aRect, phonebook* book, Cfile_output_base * log, CAknIconArray * aIconlist, CAknView * view);
        ~CContextContactsContainer();
    public:

	TInt get_current_idx();
	TInt get_current_top_idx();
	void set_current_idx(TInt real_idx);
	void set_current_top_idx(TInt real_idx);
	
	CArrayFix<TInt> * get_visible_selection();
        
	// MARK-related functions 
	void MarkCurrentItemL();
	void MarkAllL();
	void UnmarkAll();

	TBool IsCurrentMarked();
	TInt CountVisibleItems();

	// phonebook_observer
	void contents_changed();	
	void before_change();
	void exiting();

	void SizeChangedForFindBox();

	// Functions that should migrate to the view
	void show_presence_details_current();
	void show_presence_description_current();

	class CPresenceArray *iListBoxArray;
	class CNameArray* iNameArray;
private:
        void SizeChanged();
        TInt CountComponentControls() const;
        CCoeControl* ComponentControl(TInt aIndex) const;

        void Draw(const TRect& aRect) const;
        void HandleControlEventL(CCoeControl* aControl,TCoeEvent aEventType);
        void HandleListBoxEventL(CEikListBox* aListBox,TListBoxEvent aEventType);
        
	CAknSearchField* CreateFindBoxL(CEikListBox* aListBox,CTextListBoxModel* aModel, CAknSearchField::TSearchFieldStyle aStyle );
	TKeyResponse OfferKeyEventL(const TKeyEvent &, TEventCode);

private:
	doublelinebox* iListbox;
    	CAknSearchField* iFindBox;
	phonebook * aBook;

	CAknListBoxFilterItems * iFilter;
	CAknIconArray * iIconlist;
	Cfile_output_base * aLog;
	CAknView * aView;
	CArrayFix<TInt> * iCurrentVisibleSelection;
	TInt iCurrentIdx;
	TInt iTopIdx;
	TBuf<100> iSearchText, iPrevSearch;
};
#endif

