#ifndef CONTEXTCONTACTSVIEW_H
#define CONTEXTCONTACTSVIEW_H

#include <aknview.h>
#include "phonebook.h"
#include "phonehelper.h"
#include "jabberdata.h"
#include "file_output_base.h"
#include <akniconarray.h> 
#include <sendui.h> 

const TUid KViewId = {1};
class CContextContactsContainer;

class CContextContactsView : public CAknView, public MContextBase
{
    public: 
	CContextContactsView(CJabberData * jabberData, Cfile_output_base * log, phonebook* book, CAknIconArray * iconlist, phonehelper& phoneHelper) : aJabberData(jabberData), aLog(log), aBook(book), aIconlist(iconlist), aPhoneHelper(phoneHelper), mailbox_defined(EFalse), current_contact_idx(-1), current_contact_top_idx(-1) { }
        void ConstructL();
        ~CContextContactsView();
    public: 
        TUid Id() const;
        void HandleClientRectChange();
	void HandleCommandL(TInt aCommand);
	void DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane);
	TInt GetCurrentContactId();
	void before_exit();

    private:
        void DoActivateL(const TVwsViewId& aPrevViewId,TUid aCustomMessageId, const TDesC8& aCustomMessage);
        void DoDeactivate();

    private:
	virtual CContextContactsContainer* create_container();
	void set_nick();
	
private: 
        CContextContactsContainer* iContainer;
	phonebook * aBook;
	bool exiting;
	CJabberData* aJabberData;
	Cfile_output_base * aLog;
	CAknIconArray * aIconlist;
	HBufC *iCaptionUnmark;
	CSendAppUi * iSendAppUi;
	phonehelper& aPhoneHelper;
	TBool mailbox_defined;
	TInt current_contact_idx;
	TInt current_contact_top_idx;
};
#endif

