#include "ContextContactsAppUi.h"
#include "ContextContactsView.h"
#include "ContextContactsContainer.h"
#include "ContextContactsView2.h"
#include <ContextContacts.rsg>
#include "contextcontacts.hrh"

#include <avkon.hrh>
#include "icons.h"

#include "db.h"
#include <RPbkViewResourceFile.h>
#include <CPbkContactEditorDlg.h>
#include <CPbkContactEngine.h>
#include <CPbkSelectFieldDlg.h>
#include <CPbkContactItem.h>
#include <apgcli.h>
#include <eikmenup.h>
#include <CPbkViewState.h>
#include <bautils.h>
#include <aknmessagequerydialog.h> 
#include <flogger.h>
#include <EikDll.h>
#include "contextcontactsapp.h"
#include "settings.h"
#include "cl_settings.h"
#include "callstack.h"
#include "app_context_impl.h"
#include "presencedescriptionview.h"

//#define COUNTING 1

const TInt KUidToBackgroundValue=0x2004;
const TUid KUidToBackground={KUidToBackgroundValue};


void CContextContactsAppUi::ConstructL()
{	
	CALLSTACKITEM_N(_CL("CContextContactsAppUi"), _CL("ConstructL"));

	iWait=CTimeOut::NewL(*this);
	iWaitingOps=CList<TCallBack>::NewL();

	BaseConstructL();

	// LOGGING ON or OFF
	TBool logging=ETrue;
	{ TRAPD (err, Settings().GetSettingL(SETTING_LOGGING_ENABLE, logging)); }
	iLog=Cfile_output_base::NewL(AppContext(), _L("book_log"), logging, false);
	if (!logging && iLog) iLog->paused=true;

	if (iLog) {
		iLog->write_time();
		iLog->write_to_output(_L("Starting 1"));
		iLog->write_nl();
	}

#ifndef __WINS__
	// works only for context_log on the emulator
	{ TRAPD(errs, StartStarterL(_L("contacts"), KUidContextContacts, true)); }
#endif
	if (iLog) {
		iLog->write_time();
		iLog->write_to_output(_L("Starting 1.1"));
		iLog->write_nl();
	}

	TRAPD(err, { iJabberDb=CDb::NewL(AppContext(), _L("JABBER"), EFileWrite|EFileShareAny); } );
	if (err == KErrNone) {
		iJabberData=CJabberData::NewL(AppContext(), *iJabberDb);
		iPresenceHolder=CPresenceHolder::NewL(*iJabberData);
	}
	else if (iLog) 
	{
		iLog->write_time();
		iLog->write_to_output(_L("error reading jabber db."));
		iLog->write_nl();
	}

	if (iLog) {
		iLog->write_time();
		iLog->write_to_output(_L("Starting 1.2"));
		iLog->write_nl();
	}

	iBook=new (ELeave) phonebook(AppContext(), iJabberData, iPresenceHolder);
	iBook->ConstructL();

	iPhoneHelper = new (ELeave) phonehelper(iLog);
	iPhoneHelper->ConstructL();

	if (iPresenceHolder) iPresenceHolder->AddListener(iBook);
	if (iPresenceHolder) iPresenceHolder->AddListener(this);

	if (iLog) {
		iLog->write_time();
		iLog->write_to_output(_L("Starting 1.3"));
		iLog->write_nl();
	}

	iPresenceUpdater = new (ELeave) CPresenceUpdater(*iBook);
	iPresenceUpdater->ConstructL();

	if (iLog) {
		iLog->write_time();
		iLog->write_to_output(_L("Starting 1.4"));
		iLog->write_nl();
	}

	// for phonebook dialogs
	iResource_files=new (ELeave) CArrayFixFlat<TInt>(5);
	TFileName resfile=_L("z:\\System\\data\\PBKVIEW.RSC");
	BaflUtils::NearestLanguageFile(iEikonEnv->FsSession(), resfile); //for localization
	iResource_files->AppendL(iEikonEnv->AddResourceFileL(resfile));

	if (iLog) {
		iLog->write_time();
		iLog->write_to_output(_L("Starting 2"));
		iLog->write_nl();
	}

#ifdef GROUP_TAB
	CEikStatusPane* sp = StatusPane();
	iNaviPane = (CAknNavigationControlContainer*)sp->ControlL( 
        TUid::Uid(EEikStatusPaneUidNavi));
	iDecoratedTabGroup = iNaviPane->ResourceDecorator();
	if (iDecoratedTabGroup)
        {
		iTabGroup = (CAknTabGroup*) iDecoratedTabGroup->DecoratedControl();
        }
	iNaviPane->PushL(*iDecoratedTabGroup);
#endif

	if (iLog) {
		iLog->write_time();
		iLog->write_to_output(_L("Starting 2.1"));
		iLog->write_nl();
	}

	iIconlist = new (ELeave) CAknIconArray(30);
	TRAPD(icon_err, LoadIcons(iIconlist));
	if (icon_err!=KErrNone) {
		TBuf<30> msg=_L("error ");
		msg.AppendNum(icon_err);
		msg.Append(_L(" "));
		HBufC* stack=CallStackMgr().GetFormattedCallStack(_L("AppUi"));
		if (iLog) {
			iLog->write_time();
			iLog->write_to_output(msg);
			iLog->write_to_output(*stack);
			iLog->write_nl();
		}
		delete stack;
		User::Leave(icon_err);
	}

	if (iLog) {
		iLog->write_time();
		iLog->write_to_output(_L("Starting 2.2"));
		iLog->write_nl();
	}

	iContactsView = new (ELeave) CContextContactsView(iJabberData, iLog, iBook, iIconlist, *iPhoneHelper);
	CleanupStack::PushL( iContactsView );
	iContactsView->ConstructL();
	AddViewL( iContactsView );      // transfer ownership to CAknViewAppUi
	CleanupStack::Pop();    

	iGroupsView = new (ELeave) CContextContactsView2;
	CleanupStack::PushL( iGroupsView );
	iGroupsView->ConstructL();
	AddViewL( iGroupsView );      // transfer ownership to CAknViewAppUi
	CleanupStack::Pop();   

	iContactDetailView = new (ELeave) CContextContactsDetailView(*iPhoneHelper, iIconlist);
	CleanupStack::PushL( iContactDetailView );
	iContactDetailView->ConstructL();
	AddViewL( iContactDetailView );      // transfer ownership to CAknViewAppUi
	CleanupStack::Pop();  

	auto_ptr<CPresenceDetailView> detailview(CPresenceDetailView::NewL());
	AddViewL(detailview.get());
	iPresenceDetailView=detailview.release();

	auto_ptr<CPresenceDescriptionView> Descriptionview(CPresenceDescriptionView::NewL());
	AddViewL(Descriptionview.get());
	iPresenceDescriptionView=Descriptionview.release();

	/*auto_ptr<CSettingsView> iSettingsView(CSettingsView::NewL(AppContext(), *iBook));
	AddViewL(iSettingsView.get());
	iSettingsView.release();
	*/

	SetDefaultViewL(*iContactsView);

	iEikonEnv->AddForegroundObserverL(*this);

	if (iLog) {
		iLog->write_time();
		iLog->write_to_output(_L("Starting 3"));
		iLog->write_nl();
	}

}

CContextContactsAppUi::~CContextContactsAppUi()
{
	CALLSTACKITEM_N(_CL("CContextContactsAppUi"), _CL("~CContextContactsAppUi"));

	if (iLog) 
	{
		iLog->write_time();
		iLog->write_to_output(_L("Closing Contacts"));
		iLog->write_nl();
	}
	delete iWaitingOps;
	delete iWait;

	iContactsView->before_exit();

	iEikonEnv->RemoveForegroundObserver(*this);
	for (int i=0; i<iResource_files->Count(); i++) {
		iEikonEnv->DeleteResourceFile((*iResource_files)[i]);
	}
	delete iResource_files;
	delete iPhoneHelper;

     	delete iLog;
	delete iBook;
	delete iPresenceHolder;
	delete iPresenceUpdater;
	delete iJabberData;
	delete iJabberDb;
	delete iDecoratedTabGroup; 
	delete iIconlist;
}

TKeyResponse CContextContactsAppUi::HandleKeyEventL(
    const TKeyEvent& aKeyEvent, TEventCode /*aType*/)
{
	CALLSTACKITEM_N(_CL("CContextContactsAppUi"), _CL("HandleKeyEventL"));

	if ( iTabGroup == NULL )
        {
		return EKeyWasNotConsumed;
        }
	TInt active = iTabGroup->ActiveTabIndex();
	TInt count = iTabGroup->TabCount();

	switch ( aKeyEvent.iCode )
        {
		case EKeyLeftArrow:
			if ( active > 0 )
			{
				active--;
				iTabGroup->SetActiveTabByIndex( active );
				ActivateLocalViewL(TUid::Uid(iTabGroup->TabIdFromIndex(active)));
			}
			break;
		case EKeyRightArrow:
			if( (active + 1) < count )
			{
				active++;
				iTabGroup->SetActiveTabByIndex( active );
				ActivateLocalViewL(TUid::Uid(iTabGroup->TabIdFromIndex(active)));
			}
			break;
		default:
			return EKeyWasNotConsumed;
			break;
        }
	return EKeyWasConsumed;
}

void CContextContactsAppUi::HandleCommandL(TInt aCommand)
{
	CALLSTACKITEM_N(_CL("CContextContactsAppUi"), _CL("HandleCommandL"));

	switch ( aCommand )
	{
		case EEikCmdExit:
		{
			iContactsView->before_exit();
			Exit();
			break;
		}
		case EContextContactsCmdCrash:
		{
			TBuf<2> b; b.Append(_L("xxx"));
		}
		case EAknSoftkeyBack:
		{
			hide();
			break;
		}
		case EContextContactsCmdInfoMem:
		{
			TInt err, size=0, nb_contacts = -1;
			TInt64 free = -1;
                        TEntry entry;
			TVolumeInfo info;
			_LIT(KContactsDb, "c:\\System\\Data\\Contacts.cdb");
			
			nb_contacts = iBook->Count();
			err = Fs().Entry(KContactsDb, entry);
			if (err == KErrNone) size = entry.iSize;
			err = Fs().Volume(info);
			if (err == KErrNone) free = info.iFree;

			TReal x = size/1024;
			TReal y = (free/1024).GetTReal();

			HBufC * header = CEikonEnv::Static()->AllocReadResourceL(R_CONTACTS_INFO_BUF);
			CleanupStack::PushL(header);
			TBuf<200> message;
			TRealFormat realFormat = TRealFormat(30, 0);
			//FIX ME: use resource
			message.AppendFormat(_L("%d contacts\n"), nb_contacts);
			message.AppendNum(x, realFormat);
			message.Append(_L(" kB used\n"));
			message.AppendNum(y, realFormat);
			message.Append(_L(" kB free\n"));
			          			
			CAknMessageQueryDialog * dlg = CAknMessageQueryDialog::NewL(message);
			CleanupStack::PushL(dlg);
			dlg->PrepareLC(R_CONTACTS_INFO);
			dlg->QueryHeading()->SetTextL(*header);
			CleanupStack::Pop(dlg);
			
			dlg->RunLD();
			CleanupStack::PopAndDestroy(1); //header
			break;
		}
		
		case EContextContactsCmdOpen:
		{
			CPbkViewState* pbkViewParam = CPbkViewState::NewLC(); 
			TInt contact_id = iContactsView->GetCurrentContactId(); 
			pbkViewParam->SetFocusedContactId( contact_id ); 
			HBufC8* paramBuf = pbkViewParam->PackLC();
			ActivateLocalViewL(KDetailViewId, CPbkViewState::Uid(), *paramBuf); 
			CleanupStack::PopAndDestroy(2); // paramBuf, pbkViewPara
			break;
		}
		case EContextContactsCmdSimDir:
		{
#ifndef __WINS__
			auto_ptr<CApaCommandLine> cmd(CApaCommandLine::NewL(_L("z:\\system\\apps\\simdirectory\\simdirectory.app")));
#else
			auto_ptr<CApaCommandLine> cmd(CApaCommandLine::NewL(_L("z:\\system\\apps\\calcsoft\\calcsoft.app")));
#endif
			cmd->SetCommandL(EApaCommandRun);
			TRAPD(err, EikDll::StartAppL(*cmd));
			break;
		}
		case EContextContactsCmdSettings:
		{
			//ActivateLocalViewL(KSettingsViewId);
			break;
		}
		default:
			break;      
        }
}

void CContextContactsAppUi::hide()
{
	CALLSTACKITEM_N(_CL("CContextContactsAppUi"), _CL("hide"));

	RWsSession& wsSession=CEikonEnv::Static()->WsSession();
	
	TApaTask task(wsSession);
	TInt id = CEikonEnv::Static()->RootWin().Identifier();
	task.SetWgId(id);
		
	if ( wsSession.GetFocusWindowGroup() == id )
	{
		task.SendToBackground();
	}
}

void CContextContactsAppUi::HandleGainingForeground()
{
	CALLSTACKITEM_N(_CL("CContextContactsAppUi"), _CL("HandleGainingForeground"));

	if (iLog) {
		iLog->write_time();
		iLog->write_to_output(_L("To foreground"));
		iLog->write_nl();
	}
	if (iPresenceUpdater) iPresenceUpdater->Start();
}

void CContextContactsAppUi::HandleLosingForeground()
{
	CALLSTACKITEM_N(_CL("CContextContactsAppUi"), _CL("HandleLosingForeground"));

	if (iLog) {
		iLog->write_time();
		iLog->write_to_output(_L("To background\n"));
		iLog->write_nl();
	}
	if (iPresenceUpdater) iPresenceUpdater->Stop();

}

void CContextContactsAppUi::Notify(const TDesC& /*aMessage*/)
{
	CALLSTACKITEM_N(_CL("CContextContactsAppUi"), _CL("Notify"));

	// no impl	
}

void CContextContactsAppUi::PresenceChangedL(TInt /*ContactId*/, CBBPresence* /*info*/)
{
	CALLSTACKITEM_N(_CL("CContextContactsAppUi"), _CL("PresenceChangedL"));

	// no implementation
}

void CContextContactsAppUi::DisplayPresenceDetailsL(const TDesC& Name, 
						    const CBBPresence* PresenceData)
{
	CALLSTACKITEM_N(_CL("CContextContactsAppUi"), _CL("DisplayPresenceDetailsL"));

	if (PresenceData == 0) return;
	iPresenceDetailView->SetData(Name, PresenceData);
	ActivateLocalViewL(KPresenceDetailView);
}

void CContextContactsAppUi::DisplayPresenceDescriptionL(const TDesC& Name, 
						    const CBBPresence* PresenceData)
{
	CALLSTACKITEM_N(_CL("CContextContactsAppUi"), _CL("DisplayPresenceDescriptionL"));

	if (PresenceData == 0) return;
	iPresenceDescriptionView->SetData(Name, PresenceData);
	ActivateLocalViewL(KPresenceDescriptionView);
}


void CContextContactsAppUi::QueueOp(TCallBack Op, int AfterSeconds)
{
	CALLSTACKITEM_N(_CL("CContextContactsAppUi"), _CL("QueueOp"));

	iWaitingOps->AppendL(Op);
	iWait->Wait(AfterSeconds);
}
void CContextContactsAppUi::expired(CBase*)
{
	CALLSTACKITEM_N(_CL("CContextContactsAppUi"), _CL("expired"));

	TCallBack op=iWaitingOps->Pop();
	((*this).*op)();
	while (iWaitingOps->iFirst && iWaitingOps->Top()==op) iWaitingOps->Pop();
	if (iWaitingOps->iFirst) {
		iWait->Wait(1);
	}
}

void CContextContactsAppUi::ProcessMessageL(TUid aUid, const TDesC8& aParams)
{
	CALLSTACKITEM_N(_CL("CContextContactsAppUi"), _CL("ProcessMessageL"));

	RFileLogger iLog;
	iLog.Connect();
	iLog.CreateLog(_L("test"),_L("c.txt"),EFileLoggingModeAppend);
	iLog.Write(_L("here"));
	iLog.CloseLog();
	iLog.Close();

	if (aUid==KUidToBackground) {
		QueueOp(&CContextContactsAppUi::hide);
	} else {
		CAknViewAppUi::ProcessMessageL(aUid,aParams);
	}
}

void CContextContactsAppUi::HandleWsEventL(const TWsEvent& aEvent,CCoeControl* aDestination)
{
	CALLSTACKITEM_N(_CL("CContextContactsAppUi"), _CL("HandleWsEventL"));


	if (aEvent.Type() == 999)
	{
		QueueOp(&CContextContactsAppUi::hide);
	
	}
	else
	{
		CAknViewAppUi::HandleWsEventL(aEvent, aDestination);
	}

}

