#include "ContextContactsDetailContainer.h"

#include <eikspane.h>
#include <akntitle.h> 
#include <aknnavi.h> 
#include <eikmenup.h>
#include <aknlists.h> 
#include <ContextContacts.rsg>
#include "contextcontacts.hrh"
#include <avkon.hrh>
#include <cpbkfieldinfo.h> 
#include "icons.h"
#include <pbkiconinfo.h> 
#include <gulicon.h>

#include "app_context.h"

enum KEYCODES {
	JOY_LEFT = 0xF807,
	JOY_RIGHT = 0xF808,
	JOY_UP = 0xF809,
	JOY_DOWN = 0xF80A,
	JOY_CLICK = 0xF845,
	KEY_CALL = 0xF862,
	KEY_CANCEL = 0xF863,
	KEY_C = 0x0008
};

void CContextContactsDetailContainer::ConstructL(const TRect& aRect, CPbkContactItem * item, CAknIconArray * aIconlist, CAknView * view)
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("ConstructL"));
	
	CreateWindowL();
	aItem=item;
	aView = view;
	
	iIconlist = new (ELeave) CAknIconArray(1);
	for (TInt i = 0; i< aIconlist->Count();i++)
	{
		CGulIcon * ic, *icon_from; 
		icon_from= (*aIconlist)[i];
		ic=CGulIcon::NewL( icon_from->Bitmap(), icon_from->Mask());
		ic->SetBitmapsOwnedExternally(ETrue);
		iIconlist->AppendL( ic );
	}
	
	// title
	CEikStatusPane* sp=iEikonEnv->AppUiFactory()->StatusPane();
	CAknTitlePane* tp=(CAknTitlePane*)sp->ControlL(TUid::Uid(EEikStatusPaneUidTitle));
	tp->SetText(aItem->GetContactTitleL());
	//navi pane
	CAknNavigationControlContainer	*np = (CAknNavigationControlContainer *)sp->ControlL(TUid::Uid(EEikStatusPaneUidNavi)); 
	np->PushDefaultL (); 
	
	iItemArray = new (ELeave) CDesC16ArrayFlat(50);
	iIdxArray   = new (ELeave) CArrayFixFlat<TPbkFieldId>(50);
	
	populate_listbox();
	
	iListbox = new (ELeave)  CAknDoubleGraphicStyleListBox ;
	iListbox->SetContainerWindowL(*this);
	iListbox->ConstructL(this, EAknListBoxSelectionList);
	iListbox->View()->SetMatcherCursor(EFalse);
	iListbox->ItemDrawer()->FormattedCellData()->SetIconArray(iIconlist);
	iListbox->SetListBoxObserver(this);
	iListbox->Model()->SetItemTextArray(iItemArray);
	iListbox->Model()->SetOwnershipType(ELbmDoesNotOwnItemArray);
	//FIX ME:
	iListbox->View()->SetListEmptyTextL(_L("(no contact details)"));
	iListbox->CreateScrollBarFrameL(ETrue);
	iListbox->ScrollBarFrame()->SetScrollBarVisibilityL( CEikScrollBarFrame::EOff, CEikScrollBarFrame::EAuto);
	iListbox->MakeVisible(ETrue);
	iListbox->SetRect(aRect);
	iListbox->ActivateL();
	iListbox->DrawNow();
	
	SetRect(aRect);
	ActivateL();
}


CContextContactsDetailContainer::~CContextContactsDetailContainer()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("~CContextContactsDetailContainer"));
	
	CEikStatusPane* sp=iEikonEnv->AppUiFactory()->StatusPane();
        CAknNavigationControlContainer* np = (CAknNavigationControlContainer *)sp->ControlL(TUid::Uid(EEikStatusPaneUidNavi));
        np->Pop(NULL); 
	
	delete iIdxArray;
	delete iListbox;
	delete iItemArray;
}

void CContextContactsDetailContainer::SizeChanged()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("SizeChanged"));
	
	iListbox->SetRect(Rect());
}


TInt CContextContactsDetailContainer::CountComponentControls() const
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("CountComponentControls"));
	
	return 1; // return nbr of controls inside this container
}

CCoeControl* CContextContactsDetailContainer::ComponentControl(TInt aIndex) const
{
	switch ( aIndex )
        {
	case 0:
		return iListbox;
        default:
		return NULL;
        }
}

void CContextContactsDetailContainer::Draw(const TRect& aRect) const
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("Draw"));
	
	CWindowGc& gc = SystemGc();
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushColor(KRgbGray);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.DrawRect(aRect);
}

void CContextContactsDetailContainer::HandleControlEventL(
							  CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("HandleControlEventL"));
	
}

TKeyResponse CContextContactsDetailContainer::OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType)
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("OfferKeyEventL"));
	
	if ( aType != EEventKey ) // Is not key event?
        {
		return EKeyWasNotConsumed;
        }
	if (aKeyEvent.iCode==JOY_LEFT || aKeyEvent.iCode == JOY_RIGHT)
	{
		return EKeyWasConsumed;
	}   
	if ( iListbox )
        {
		if (aKeyEvent.iCode==JOY_DOWN || aKeyEvent.iCode == JOY_UP || aKeyEvent.iCode == JOY_CLICK)
		{
			return iListbox->OfferKeyEventL(aKeyEvent, aType);
		}
		else if (aKeyEvent.iCode == KEY_CALL)
		{
			if (ItemCount() >0 )
			{
				aView->HandleCommandL(EContextContactsCmdCall);
			}
			return EKeyWasConsumed;
		}
		else if (aKeyEvent.iCode == KEY_C)
		{
			if (ItemCount() >0 )
			{
				aView->HandleCommandL(EContextContactsCmdDelete);
			}
			return EKeyWasConsumed;
		}
	}
	return EKeyWasNotConsumed;
}

TInt CContextContactsDetailContainer::get_current_item_idx()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("get_current_item_idx"));
	
	if (ItemCount() == 0) return -1;
	return iIdxArray->At( get_current_idx() );
}

TInt CContextContactsDetailContainer::get_current_idx()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("get_current_idx"));
	
	if (ItemCount() == 0) return -1;
	return iListbox->View()->CurrentItemIndex();
}

void CContextContactsDetailContainer::HandleListBoxEventL(CEikListBox* aListBox,TListBoxEvent aEventType)
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("HandleListBoxEventL"));
	
	if(aListBox == iListbox)
	{
		switch(aEventType)
		{
		case EEventEnterKeyPressed:
			{
				if (ItemCount() >0 )
				{
					aView->MenuBar()->SetMenuTitleResourceId(R_CONTEXTCONTACTS_MENUBAR_DETAIL_SPECIFIC_VIEW);
					aView->MenuBar()->TryDisplayMenuBarL();
					aView->MenuBar()->SetMenuTitleResourceId(R_CONTEXTCONTACTS_MENUBAR_DETAIL_VIEW);
				}
				break;
			}
		default:
			break;
		}
	}	
}

TBool CContextContactsDetailContainer::IsCurrentPhoneNumber()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("IsCurrentPhoneNumber"));
	
	TInt idx = iIdxArray->At( get_current_idx() );
	TPbkFieldId id = aItem->PbkFieldAt(idx).PbkFieldId();
	
	TPbkContactItemField * field = aItem->FindField(id, idx);
	return (field->FieldInfo().IsPhoneNumberField());
}

TBool CContextContactsDetailContainer::HasPhoneNumber()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("HasPhoneNumber"));
	
	for (int i=0; i<iIdxArray->Count(); i++)
	{
		TInt idx = iIdxArray->At(i);
		TPbkFieldId id = aItem->PbkFieldAt(idx).PbkFieldId();
		TPbkContactItemField * field = aItem->FindField(id, idx);
		if (field->FieldInfo().IsPhoneNumberField()) return ETrue;
	}
	return EFalse;
}

TBool CContextContactsDetailContainer::IsCurrentMMS()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("IsCurrentMMS"));
	
	TInt idx = iIdxArray->At( get_current_idx() );
	TPbkFieldId id = aItem->PbkFieldAt(idx).PbkFieldId();
	
	TPbkContactItemField * field = aItem->FindField(id, idx);
	return (field->FieldInfo().IsMmsField());
}

TBool CContextContactsDetailContainer::HasMmsAddress()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("HasMmsAddress"));
	
	for (int i=0; i<iIdxArray->Count(); i++)
	{
		TInt idx = iIdxArray->At( i );
		TPbkFieldId id = aItem->PbkFieldAt(idx).PbkFieldId();
		TPbkContactItemField * field = aItem->FindField(id, idx);
		if (field->FieldInfo().IsMmsField()) return ETrue;
	}
	return EFalse;
}

TBool CContextContactsDetailContainer::HasEmailAddress()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("HasEmailAddress"));
	
	for (int i=0; i<iIdxArray->Count(); i++)
	{
		TInt idx = iIdxArray->At( i );
		TPbkFieldId id = aItem->PbkFieldAt(idx).PbkFieldId();
		TPbkContactItemField * field = aItem->FindField(id, idx);
		if (field->FieldInfo().IsMmsField() && !(field->FieldInfo().IsPhoneNumberField())) return ETrue;
	}
	return EFalse;
}

TBool CContextContactsDetailContainer::IsCurrentWebAddress()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("IsCurrentWebAddress"));
	
	TInt idx = iIdxArray->At( get_current_idx() );
	TPbkFieldId id = aItem->PbkFieldAt(idx).PbkFieldId();
	
	TPbkContactItemField * field = aItem->FindField(id, idx);
	TInt offset = field->PbkFieldText().Find(_L("http://"));
	return (offset!=KErrNotFound);
}

TBuf<255> CContextContactsDetailContainer::GetWebAddress()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("GetWebAddress"));
	
	TBuf<255> url;
	
	// let's try current item
	TInt idx = iIdxArray->At( get_current_idx() );
	TPbkFieldId id = aItem->PbkFieldAt(idx).PbkFieldId();
	
	TPbkContactItemField * field = aItem->FindField(id, idx);
	TInt offset = field->PbkFieldText().Find(_L("http://"));
	if (offset!=KErrNotFound)
	{
		url.Copy(field->PbkFieldText());
		return url;
	}
	else
	{
		// looks like it's somewhere else
		for (int i=0; i<iIdxArray->Count(); i++)
		{
			TInt idx = iIdxArray->At( i );
			TPbkFieldId id = aItem->PbkFieldAt(idx).PbkFieldId();
			TPbkContactItemField * field = aItem->FindField(id, idx);
			TInt offset = field->PbkFieldText().Find(_L("http://"));
			if (offset!=KErrNotFound) 
			{
				url.Copy(field->PbkFieldText());
				return url;
			}
		}
		return url;
	}
}

void CContextContactsDetailContainer::populate_listbox()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("populate_listbox"));
	
	iItemArray->Reset();
	iIdxArray->Reset();
	iItemArray->Compress();
	iIdxArray->Compress();
	
	CPbkIconInfoContainer * iconInfoContainer = CPbkIconInfoContainer::NewL();  
	CleanupStack::PushL(iconInfoContainer);
        
	TInt previous_idx = -1;
	for (int i=0; i<aItem->PbkFieldCount(); i++)
	{
		previous_idx++;
		TPbkFieldId id = aItem->PbkFieldAt(i).PbkFieldId();
		TPbkContactItemField * field = aItem->FindField(id, (previous_idx));
		previous_idx = aItem->FindFieldIndex(*field);
		
		if ( (field->FieldInfo().NameField() == EFalse)  )
		{
			if ( field->FieldInfo().IsImageField() )
			{
				//FIXME: do something with the panel
			}
			else if ( field->FieldInfo().FieldStorageType() == KStorageTypeDateTime )
			{
				
				//do something with birthdate
				TBuf<200> temp; // 255 ?
				TInt icon = iconInfoContainer->Find(field->IconId())->IconId();
				temp.AppendFormat(_L("%d\t"), GetIconIndex(icon) );  // icon id
				temp.Append(field->Label());
				temp.Append(_L("\t"));
				
				TBuf<30> date;
				TTime time = field->PbkFieldTime();
				time.FormatL(date, _L("%D%M%Y%/0%1%/1%2%/2%3%/3") );
				
				temp.Append(date);
				iItemArray->AppendL(temp);
				iIdxArray->AppendL(i); 
			}
			else
			{
				if ( field->Label().Length() != 0 )
				{
					TBuf<200> temp; // 255 ?
					TInt icon = iconInfoContainer->Find(field->IconId())->IconId();
					temp.AppendFormat(_L("%d\t"), GetIconIndex(icon) );  // icon id
					temp.Append(field->Label());
					temp.Append(_L("\t"));
					temp.Append(field->Text());
					iItemArray->AppendL(temp);
					iIdxArray->AppendL(i);
				}
			}
		}
	}
	CleanupStack::PopAndDestroy(1); // iconcontainer
}

void CContextContactsDetailContainer::refresh(CPbkContactItem * item)
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("refresh"));
	
	aItem = item;
	
	// title
	CEikStatusPane* sp=iEikonEnv->AppUiFactory()->StatusPane();
	CAknTitlePane* tp=(CAknTitlePane*)sp->ControlL(TUid::Uid(EEikStatusPaneUidTitle));
	tp->SetText(aItem->GetContactTitleL());
	
	populate_listbox();
	iListbox->HandleItemRemovalL();
	iListbox->SetCurrentItemIndexAndDraw(0);
}

TInt CContextContactsDetailContainer::ItemCount()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailContainer"), _CL("ItemCount"));
	
	return iListbox->Model()->ItemTextArray()->MdcaCount();
}