#include  <aknviewappui.h>
#include  <avkon.hrh>
#include  <ContextContacts.rsg>
#include  "ContextContactsDetailView.h"
#include  "ContextContactsDetailContainer.h" 
#include  "ContextContacts.hrh"
#include  <SenduiMtmUids.h>
#include  <txtrich.h>
#include  <MsgBioUids.h>
#include <sendnorm.rsg>
#include <cpbkphonenumberselect.h> 
#include <cpbksmsaddressselect.h> 
#include <cpbkmmsaddressselect.h> 
#include <cpbkemailaddressselect.h> 
#include <aknmessagequerydialog.h> 
#include <aknlists.h> 
#include <cpbkselectfielddlg.h> 
#include <cpbkfieldinfo.h> 
#include <viewcli.h>

#ifndef __S60V2__
#include "browser_interface.h"
#endif

class CDefaultNumbersPopupList : public CAknPopupList {
public:
	static CDefaultNumbersPopupList * NewL(CPbkContactItem * item);
	~CDefaultNumbersPopupList();
protected:
	void ConstructL();
	void ProcessCommandL (TInt aCommandId); 
	void HandleListBoxEventL (CEikListBox *aListBox, TListBoxEvent aEventType); 
private:
	CDefaultNumbersPopupList(CPbkContactItem * item) : CAknPopupList(), aItem(item) {}
	void DisplaySelection();
	void Refresh();
	void PopulateListbox();
private:
	CPbkContactItem * aItem;
	CDesCArrayFlat * iArrayItems;
	CEikTextListBox * iListbox;
	HBufC * iPhoneDefault;
	HBufC * iSmsDefault;
	HBufC * iMmsDefault;
	HBufC * iEmailDefault;
	HBufC * iNoDefault;
	HBufC * iDefault;
};

CDefaultNumbersPopupList * CDefaultNumbersPopupList::NewL(CPbkContactItem * item)
{
	CALLSTACKITEM_N(_CL("CDefaultNumbersPopupList"), _CL("NewL"));


	auto_ptr<CDefaultNumbersPopupList> ret(new (ELeave) CDefaultNumbersPopupList(item));
	ret->ConstructL();
	return ret.release();
}

void CDefaultNumbersPopupList::Refresh()
{
	CALLSTACKITEM_N(_CL("CDefaultNumbersPopupList"), _CL("Refresh"));


	iArrayItems->Reset();
	iArrayItems->Compress();
	PopulateListbox();
	iListbox->HandleItemRemovalL();
}

void CDefaultNumbersPopupList::PopulateListbox()
{
	CALLSTACKITEM_N(_CL("CDefaultNumbersPopupList"), _CL("PopulateListbox"));


	TBuf<200> phone;
	phone.Append(*iPhoneDefault);
	phone.Append(_L("\t"));
	if( aItem->DefaultPhoneNumberField() != 0)
	{
		phone.Append(aItem->DefaultPhoneNumberField()->Label());
	}
	else
	{
		phone.Append(*iNoDefault);
	}
	iArrayItems->AppendL(phone);

	TBuf<200> sms;
	sms.Append(*iSmsDefault);
	sms.Append(_L("\t"));
	if( aItem->DefaultSmsField() != 0)
	{
		sms.Append(aItem->DefaultSmsField()->Label());
	}
	else
	{
		sms.Append(*iNoDefault);
	}
	iArrayItems->AppendL(sms);

	TBuf<200> mms;
	mms.Append(*iMmsDefault);
	mms.Append(_L("\t"));
	if( aItem->DefaultMmsField() != 0)
	{
		mms.Append(aItem->DefaultMmsField()->Label());
	}
	else
	{
		mms.Append(*iNoDefault);
	}
	iArrayItems->AppendL(mms);

	TBuf<200> email;
	email.Append(*iEmailDefault);
	email.Append(_L("\t"));
	if( aItem->DefaultEmailField () != 0)
	{
		email.Append(aItem->DefaultEmailField()->Label());
	}
	else
	{
		email.Append(*iNoDefault);
	}
	iArrayItems->AppendL(email);
}

void CDefaultNumbersPopupList::ConstructL()
{
	CALLSTACKITEM_N(_CL("CDefaultNumbersPopupList"), _CL("ConstructL"));


	iListbox = new (ELeave)  CAknDoublePopupMenuStyleListBox;

	iPhoneDefault =CEikonEnv::Static()->AllocReadResourceL(R_DEFAULT_PHONE);
	iSmsDefault =CEikonEnv::Static()->AllocReadResourceL(R_DEFAULT_SMS);
	iMmsDefault =CEikonEnv::Static()->AllocReadResourceL(R_DEFAULT_MMS);
	iEmailDefault =CEikonEnv::Static()->AllocReadResourceL(R_DEFAULT_EMAIL);
	iNoDefault =CEikonEnv::Static()->AllocReadResourceL(R_NO_DEFAULT);
	iDefault = CEikonEnv::Static()->AllocReadResourceL(R_DEFAULTS);

	iArrayItems = new CDesCArrayFlat(1);
	PopulateListbox();

	// original contsructl
	CAknPopupList::ConstructL(iListbox, R_DEFAULT_POPUP_CBA, AknPopupLayouts::EMenuDoubleWindow);
	CAknPopupList::SetTitleL(*iDefault);

	iListbox->ConstructL(this, CEikListBox::ELeftDownInViewRect);
	iListbox->CreateScrollBarFrameL(ETrue);
	iListbox->ScrollBarFrame()->SetScrollBarVisibilityL(CEikScrollBarFrame::EOff, CEikScrollBarFrame::EAuto);

	CTextListBoxModel* model = iListbox->Model();
	model->SetItemTextArray(iArrayItems);
	model->SetOwnershipType(ELbmDoesNotOwnItemArray);
}

CDefaultNumbersPopupList::~CDefaultNumbersPopupList()
{
	CALLSTACKITEM_N(_CL("CDefaultNumbersPopupList"), _CL("~CDefaultNumbersPopupList"));


	delete iListbox;
	delete iArrayItems;

	delete iPhoneDefault;
	delete iSmsDefault;
	delete iMmsDefault;
	delete iEmailDefault;
	delete iNoDefault;
	delete iDefault;
}

void CDefaultNumbersPopupList::ProcessCommandL (TInt aCommandId)
{
	CALLSTACKITEM_N(_CL("CDefaultNumbersPopupList"), _CL("ProcessCommandL"));


	switch (aCommandId)
	{
		case EContextContactsCmdAssign:
		{
			DisplaySelection();
			break;
		}
		case EAknSoftkeyBack:
		default:
		{
			CAknPopupList::ProcessCommandL(aCommandId);
		}

	}
}

void CDefaultNumbersPopupList::DisplaySelection()
{
	CALLSTACKITEM_N(_CL("CDefaultNumbersPopupList"), _CL("DisplaySelection"));


	CPbkSelectFieldDlg * dlg = new CPbkSelectFieldDlg;
	CleanupStack::PushL(dlg);

	CPbkFieldArray& fields = aItem->CardFields(); //original
	CPbkFieldArray * to_display = new CPbkFieldArray(); // with selected
	CleanupStack::PushL(to_display);

	TInt idx = iListbox->CurrentItemIndex();
	TInt focus = -1;
	
	switch (idx)
	{
		case 0: //default phone
		{
			for( int i=0; i<fields.Count();i++ )
			{ 
				if ( (fields.At(i)).FieldInfo().IsPhoneNumberField() )
				{
					to_display->AppendL(fields.At(i));
					if ( (fields.At(i)).DefaultPhoneNumberField() )
					{
						focus = (to_display->Count() -1);
					}
				}
			}
			TPbkContactItemField * field = dlg->ExecuteLD(*to_display, R_SELECT_NONE_CBA,KNullDesC,focus );
			if (!field)
			{
				aItem->RemoveDefaultPhoneNumberField();
			}
			else
			{
				aItem->SetDefaultPhoneNumberFieldL(field);
			}
			break;
		}
		case 1: // default sms
		{
			for( int i=0; i<fields.Count();i++ )
			{ 
				if ( (fields.At(i)).FieldInfo().IsPhoneNumberField() )
				{
					to_display->AppendL(fields.At(i));
					if ( (fields.At(i)).DefaultSmsField() )
					{
						focus = (to_display->Count() -1);
					}
				}
			}
			TPbkContactItemField * field = dlg->ExecuteLD(*to_display, R_SELECT_NONE_CBA,KNullDesC,focus );
			if (!field)
			{
				aItem->RemoveDefaultSmsField();
			}
			else
			{
				aItem->SetDefaultSmsFieldL(field);
			}
			break;
		}
		case 2: //default mms
		{
			for( int i=0; i<fields.Count();i++ )
			{ 
				if ( (fields.At(i)).FieldInfo().IsMmsField() )
				{
					to_display->AppendL(fields.At(i));
					if ( (fields.At(i)).DefaultMmsField() )
					{
						focus = (to_display->Count() -1);
					}
				}
			}
			TPbkContactItemField * field = dlg->ExecuteLD(*to_display, R_SELECT_NONE_CBA,KNullDesC,focus );
			if (!field)
			{
				aItem->RemoveDefaultMmsField();
			}
			else
			{
				aItem->SetDefaultMmsFieldL(field);
			}
			break;
		}
		case 3: // default email
		{
			for( int i=0; i<fields.Count();i++ )
			{ 
				if ( (fields.At(i)).FieldInfo().IsMmsField() && !(fields.At(i)).FieldInfo().IsPhoneNumberField() )
				{
					to_display->AppendL(fields.At(i));
					if ( (fields.At(i)).DefaultEmailField() )
					{
						focus = (to_display->Count() -1);
					}
				}
			}
			TPbkContactItemField * field = dlg->ExecuteLD(*to_display, R_SELECT_NONE_CBA,KNullDesC, focus );
			if (!field)
			{
				aItem->RemoveDefaultEmailField();
			}
			else
			{
				aItem->SetDefaultEmailFieldL(field);
			}
			
			break;
		}
		default:
			break;
	}
	CleanupStack::PopAndDestroy(); //to_display
	CleanupStack::Pop(); // dlg
	Refresh();
}

void CDefaultNumbersPopupList::HandleListBoxEventL (CEikListBox *aListBox, TListBoxEvent aEventType)
{
	CALLSTACKITEM_N(_CL("CDefaultNumbersPopupList"), _CL("HandleListBoxEventL"));


	if (aListBox == iListbox)
	{
		if (aEventType == EEventEnterKeyPressed)
		{
			DisplaySelection();
		}
	}
}

//---------------------------------------------------------------------------------------------------


void CContextContactsDetailView::ConstructL()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailView"), _CL("ConstructL"));


	BaseConstructL( R_CONTEXTCONTACTS_DETAIL_VIEW );
	iSendAppUi=CSendAppUi::NewL(ESendCmdId);

	pbkengine = CPbkContactEngine::Static();
	if (pbkengine) 	{ owns_engine=false;} 
	else 
	{
		pbkengine=CPbkContactEngine::NewL();
		owns_engine=true;
	}
}

CContextContactsDetailView::~CContextContactsDetailView()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailView"), _CL("~CContextContactsDetailView"));


	if ( iContainer )
        {
		AppUi()->RemoveFromViewStack( *this, iContainer );
        }
	delete iContainer;
	delete iItem;
	delete iViewState;
	delete iSendAppUi;
	if (owns_engine) delete pbkengine;
}

TUid CContextContactsDetailView::Id() const
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailView"), _CL("Id"));


    return KDetailViewId;
}

void CContextContactsDetailView::HandleCommandL(TInt aCommand)
{   
	CALLSTACKITEM_N(_CL("CContextContactsDetailView"), _CL("HandleCommandL"));


	switch ( aCommand )
        {
		case EAknSoftkeyBack:
		{
			ActivateViewL(iPrevViewId);
			break;
		}
		case EContextContactsCmdCreateSms:
		{
			if ( iContainer->IsCurrentPhoneNumber() )
			{
				TPtrC no( iItem->PbkFieldAt(iContainer->get_current_item_idx()).PbkFieldText() );
				CDesCArrayFlat* recip=new CDesCArrayFlat(1);
				CleanupStack::PushL(recip);
				CDesCArrayFlat* alias=new CDesCArrayFlat(1);
				CleanupStack::PushL(alias);
				recip->AppendL(no);
				alias->AppendL( *(iItem->GetContactTitleL()) );
				aPhoneHelper.send_sms(recip, alias);
				CleanupStack::PopAndDestroy(2); // recip, alias
			}
			else
			{
                                CPbkSmsAddressSelect* sel=new (ELeave) CPbkSmsAddressSelect();
				TPtrC no(sel->ExecuteLD(*iItem, NULL, EFalse));
				if (no!=KNullDesC)
				{
					CDesCArrayFlat* recip=new CDesCArrayFlat(1);
					CleanupStack::PushL(recip);
					CDesCArrayFlat* alias=new CDesCArrayFlat(1);
					CleanupStack::PushL(alias);
					recip->AppendL(no);
					alias->AppendL( *(iItem->GetContactTitleL()) );
					aPhoneHelper.send_sms(recip, alias);
					CleanupStack::PopAndDestroy(2); // recip, alias
				}
			}			
			break;
		}
		case EContextContactsCmdCreateMms:
		{
			if ( (iContainer->IsCurrentMMS()) || (iContainer->IsCurrentPhoneNumber()) ) 
			{
				TPtrC no( iItem->PbkFieldAt(iContainer->get_current_item_idx()).PbkFieldText() );
				CDesCArrayFlat* recip=new CDesCArrayFlat(1);
				CleanupStack::PushL(recip);
				CDesCArrayFlat* alias=new CDesCArrayFlat(1);
				CleanupStack::PushL(alias);
				recip->AppendL(no);
				alias->AppendL(*(iItem->GetContactTitleL()));
				aPhoneHelper.send_mms(recip,alias);
				CleanupStack::PopAndDestroy(2); // recip, alias
			}
			else
			{
				CPbkMmsAddressSelect* sel=new (ELeave) CPbkMmsAddressSelect();
				TPtrC no(sel->ExecuteLD(*iItem, NULL, EFalse));
				if ((no!=KNullDesC))
				{
					CDesCArrayFlat* recip=new CDesCArrayFlat(1);
					CleanupStack::PushL(recip);
					CDesCArrayFlat* alias=new CDesCArrayFlat(1);
					CleanupStack::PushL(alias);
					recip->AppendL(no);
					alias->AppendL(*(iItem->GetContactTitleL()));
					aPhoneHelper.send_mms(recip,alias);
					CleanupStack::PopAndDestroy(2); // recip,alias
				}
			}
			break;
		}
		case EContextContactsCmdCreateEmail:
		{
			if ( iContainer->IsCurrentMMS())
			{
				TPtrC no( iItem->PbkFieldAt(iContainer->get_current_item_idx()).PbkFieldText() );
				CDesCArrayFlat* recip=new CDesCArrayFlat(1);
				CleanupStack::PushL(recip);
				CDesCArrayFlat* alias=new CDesCArrayFlat(1);
				CleanupStack::PushL(alias);
				recip->AppendL(no);
				alias->AppendL(*(iItem->GetContactTitleL()));
				aPhoneHelper.send_email(recip,alias);
				CleanupStack::PopAndDestroy(2); // recip,alias
			}
			else
			{
				CPbkEmailAddressSelect* sel=new (ELeave) CPbkEmailAddressSelect();
				TPtrC no(sel->ExecuteLD(*iItem, NULL, EFalse));
				if (no!=KNullDesC)
				{
					CDesCArrayFlat* recip=new CDesCArrayFlat(1);
					CleanupStack::PushL(recip);
					CDesCArrayFlat* alias=new CDesCArrayFlat(1);
					CleanupStack::PushL(alias);
					recip->AppendL(no);
					alias->AppendL(*(iItem->GetContactTitleL()));
					aPhoneHelper.send_email(recip, alias);
					CleanupStack::PopAndDestroy(2); // recip
				}
			}
			break;
		}
		case EContextContactsCmdCall:
		{
			if ( iContainer->IsCurrentPhoneNumber() )
			{
				TPtrC no( iItem->PbkFieldAt(iContainer->get_current_item_idx()).PbkFieldText() );
				aPhoneHelper.make_callL(no);
			}
			else
			{
				CPbkPhoneNumberSelect* sel=new (ELeave) CPbkPhoneNumberSelect();
				TPtrC no(sel->ExecuteLD(*iItem, NULL, EFalse));
				aPhoneHelper.make_callL(no);
			}
			break;
		}
		case EContextContactsCmdEdit:
		{
			aPhoneHelper.show_editor(iViewState->FocusedContactId(), false, iContainer->get_current_item_idx());
			Refresh();
			break;
		}
		case EContextContactsCmdDefaults:
		{
			CPbkContactItem * temp_item = pbkengine->OpenContactLCX(iViewState->FocusedContactId());
			CDefaultNumbersPopupList * popup = CDefaultNumbersPopupList::NewL(temp_item);
			CleanupStack::PushL(popup);
			popup->ExecuteLD();
			CleanupStack::Pop();//popup
			pbkengine->CommitContactL(*temp_item);
			CleanupStack::PopAndDestroy(2); // lock, temp_item

			Refresh();
			break;
		}
		case EContextContactsCmdGoToWeb:
		{
			TBuf<255> url;
			url.Copy(iContainer->GetWebAddress());
			if (url.Length() == 0) return;

			#ifndef __WINS__
		
			#  ifndef __S60V2__

			auto_ptr<CDorisBrowserInterface> ido(CDorisBrowserInterface::NewL());
			ido->AppendL(CDorisBrowserInterface::EOpenURL_STRING, url);
			ido->ExecuteL();
		
			#  else
			HBufC8* addr8=HBufC8::NewLC(url.Length());
			TPtr8 addrp=addr8->Des();
			CC()->ConvertFromUnicode(addrp, url);
		
			TUid KUidOperaBrowserUid = {0x101F4DED};
			TUid KUidOperaRenderViewUid = {0};

			TVwsViewId viewId(KUidOperaBrowserUid, KUidOperaRenderViewUid);
		
			CVwsSessionWrapper* vws;
			vws=CVwsSessionWrapper::NewLC();
			vws->ActivateView(viewId, KUidOperaRenderViewUid, *addr8);
			CleanupStack::PopAndDestroy(2);
			#  endif

			#endif
			break;
		}
		case EContextContactsCmdDelete:
		{
			//note: this isn't the behaviour of original contact app
			TInt idx = iContainer->get_current_item_idx();
			TInt id = iItem->PbkFieldAt(idx).PbkFieldId();
			TPbkContactItemField * field = iItem->FindField(id, idx);
			TInt length = field->Label().Length() + field->Text().Length() + 10;

			HBufC * header = CEikonEnv::Static()->AllocReadResourceL(R_DELETE);
			CleanupStack::PushL(header);
			HBufC * message= HBufC::NewL(length);
			CleanupStack::PushL(message);

			message->Des().Append(field->Label());
			message->Des().Append(_L(" ("));
			message->Des().Append(field->Text());
			message->Des().Append(_L(") ?"));

			CAknMessageQueryDialog * dlg = CAknMessageQueryDialog::NewL(*message);
			CleanupStack::PushL(dlg);
			dlg->PrepareLC(R_CONFIRMATION_QUERY);
			dlg->QueryHeading()->SetTextL(*header);
			CleanupStack::Pop(dlg);
			
			if ( dlg->RunLD() )
			{
				CPbkContactItem * temp_item = pbkengine->OpenContactLCX(iViewState->FocusedContactId());
				temp_item->RemoveField(iContainer->get_current_item_idx());
				pbkengine->CommitContactL(*temp_item);
				CleanupStack::PopAndDestroy(2);
			}
			CleanupStack::PopAndDestroy(2); //header, message
						
			Refresh();
			break;
		}

		default:
		{
			if (!iSendAppUi->CommandIsValidL(aCommand, TSendingCapabilities(0, 0, TSendingCapabilities::EAllMTMs)))
			{
				AppUi()->HandleCommandL( aCommand );
			}
			else
			{
				TUid mtm = iSendAppUi->MtmForCommand(aCommand);
				CArrayFixFlat<TInt> * c = new CArrayFixFlat<TInt>(1);
				CleanupStack::PushL(c);
				c->AppendL(iViewState->FocusedContactId());
				aPhoneHelper.send_as( mtm, c);
				CleanupStack::PopAndDestroy(1); // c
			}
			break;
		}
	}
}

// ---------------------------------------------------------
// CContextContactsDetailView::HandleClientRectChange()
// ---------------------------------------------------------
//
void CContextContactsDetailView::HandleClientRectChange()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailView"), _CL("HandleClientRectChange"));

	if ( iContainer )
        {
		iContainer->SetRect( ClientRect() );
        }
}

void CContextContactsDetailView::DoActivateL(
					     const TVwsViewId& aPrevViewId,TUid /*aCustomMessageId*/,
					     const TDesC8& aCustomMessage)
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailView"), _CL("DoActivateL"));

	iPrevViewId = aPrevViewId;
	delete iViewState; iViewState=0;
	iViewState = CPbkViewState::NewL(aCustomMessage);
	iItem = pbkengine->ReadContactL( iViewState->FocusedContactId() ); 
	
	mailbox_defined = aPhoneHelper.mailbox_defined();
	
	if (!iContainer)
        {
		iContainer = new (ELeave) CContextContactsDetailContainer;
		iContainer->SetMopParent(this);
		iContainer->ConstructL( ClientRect(), iItem, aIconlist, this );
		AppUi()->AddToStackL( *this, iContainer );
        }
}

void CContextContactsDetailView::DoDeactivate()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailView"), _CL("DoDeactivate"));

	if ( iContainer )
        {
		AppUi()->RemoveFromViewStack( *this, iContainer );
        }
	
	delete iContainer;
	iContainer = NULL;
}


void CContextContactsDetailView::DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane)
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailView"), _CL("DynInitMenuPaneL"));

	
	if (aResourceId == R_CONTEXTCONTACTS_DETAIL_VIEW_MENU) /*r_contextcontacts_detail_view_menu*/
	{
		
		
		if (iContainer->ItemCount() > 0)
		{
			if (!(iContainer->HasPhoneNumber())) aMenuPane->SetItemDimmed(EContextContactsCmdCall, ETrue);
			if (!(iContainer->HasMmsAddress()))   aMenuPane->SetItemDimmed(EContextContactsMenuMsg, ETrue);
			aMenuPane->SetItemDimmed(EContextContactsCmdEdit, EFalse);
			aMenuPane->SetItemDimmed(EContextContactsCmdDelete, EFalse);
			aMenuPane->SetItemDimmed(EContextContactsCmdDefaults, EFalse);
			iSendAppUi->DisplaySendMenuItemL(*aMenuPane, 6, TSendingCapabilities(0, 0, TSendingCapabilities::ESupportsAttachmentsOrBodyText  ));
			if ((iContainer->GetWebAddress().Length()==0)) aMenuPane->SetItemDimmed(EContextContactsCmdGoToWeb, ETrue);
			
		}
		else
		{
			aMenuPane->SetItemDimmed(EContextContactsCmdEdit, EFalse);
			aMenuPane->SetItemDimmed(EContextContactsCmdGoToWeb, ETrue);
			aMenuPane->SetItemDimmed(EContextContactsCmdCall, ETrue);
			aMenuPane->SetItemDimmed(EContextContactsMenuMsg, ETrue);
			aMenuPane->SetItemDimmed(EContextContactsCmdDelete, ETrue);
			aMenuPane->SetItemDimmed(EContextContactsCmdDefaults, ETrue);
		}
		
	}
	else if (aResourceId == R_CONTEXTCONTACTS_DETAIL_VIEW_SPECIFIC_MENU) /*r_contextcontacts_detail_view_specific_menu*/
	{
		aMenuPane->SetItemDimmed(EContextContactsCmdEdit, EFalse);
		aMenuPane->SetItemDimmed(EContextContactsMenuMsgCurrent, ETrue);
		aMenuPane->SetItemDimmed(EContextContactsCmdCall, ETrue);
		aMenuPane->SetItemDimmed(EContextContactsCmdGoToWeb, ETrue);
		
		if (iContainer->IsCurrentPhoneNumber())
		{
			aMenuPane->SetItemDimmed(EContextContactsCmdCall, EFalse);
			aMenuPane->SetItemDimmed(EContextContactsMenuMsgCurrent, EFalse);
		}
		if (iContainer->IsCurrentMMS())
		{
			aMenuPane->SetItemDimmed(EContextContactsMenuMsgCurrent, EFalse);
		}
		if (iContainer->IsCurrentWebAddress())
		{
			aMenuPane->SetItemDimmed(EContextContactsCmdGoToWeb, EFalse);
		}
	}
	else if (aResourceId == R_MESSAGE_CURRENT_MENU)
	{
		aMenuPane->SetItemDimmed(EContextContactsCmdCreateSms, ETrue);
		aMenuPane->SetItemDimmed(EContextContactsCmdCreateMms, ETrue);
		aMenuPane->SetItemDimmed(EContextContactsCmdCreateEmail, ETrue);
		if (iContainer->IsCurrentPhoneNumber() )
		{
			aMenuPane->SetItemDimmed(EContextContactsCmdCreateSms, EFalse);
			aMenuPane->SetItemDimmed(EContextContactsCmdCreateMms, EFalse);
			
		}
		else if (iContainer->IsCurrentMMS())
		{
			aMenuPane->SetItemDimmed(EContextContactsCmdCreateMms, EFalse);
			if (mailbox_defined)
			{
				aMenuPane->SetItemDimmed(EContextContactsCmdCreateEmail, EFalse);
			}
		}
	}
	else if (aResourceId == R_MESSAGE_MENU)
	{
		if (!mailbox_defined) aMenuPane->SetItemDimmed(EContextContactsCmdCreateEmail, ETrue);
	}
	else if (aResourceId == R_SENDUI_MENU)
	{
		iSendAppUi->DisplaySendCascadeMenuL(*aMenuPane, NULL);
	}
}

void CContextContactsDetailView::Refresh()
{
	CALLSTACKITEM_N(_CL("CContextContactsDetailView"), _CL("Refresh"));

	
	delete iItem; iItem=0;
	iItem = pbkengine->ReadContactL( iViewState->FocusedContactId() );
	iContainer->refresh(iItem);
}

