#include "ContextContactsDocument.h"
#include "ContextContactsAppUi.h"
#include "settings.h"

#include "bb_settings.h"
#include "cl_settings.h"

CContextContactsDocument::CContextContactsDocument(CEikApplication& aApp)
: CAknDocument(aApp) { }

CContextContactsDocument::~CContextContactsDocument()
{
	delete iContext;
}

void CContextContactsDocument::ConstructL()
{
	iContext=CApp_context::NewL(false, _L("contacts"));
	
#ifndef __WINS__
	TParsePtrC parse(Application()->DllName());
	iContext->SetAppDir(parse.DriveAndPath());
#else
	iContext->SetAppDir(_L("c:\\system\\apps\\contextcontacts\\"));
#endif
	iContext->SetDataDir(_L("c:\\system\\data\\context\\"), EFalse);

	CBlackBoardSettings* s=CBlackBoardSettings::NewL(*iContext, iNoDefaults, KCLSettingsTuple);

	iContext->SetSettings(s);
}

CContextContactsDocument* CContextContactsDocument::NewL(
							 CEikApplication& aApp)     // CContextContactsApp reference
{	
	CContextContactsDocument* self = new (ELeave) CContextContactsDocument( aApp );
	CleanupStack::PushL( self );
	self->ConstructL();
	CleanupStack::Pop();
	
	return self;
}


CEikAppUi* CContextContactsDocument::CreateAppUiL()
{
	CALLSTACKITEM_N(_CL("CContextContactsDocument"), _CL("CreateAppUiL"));
	
	return new (ELeave) CContextContactsAppUi(*iContext);
}

