// INCLUDE FILES
#include  <aknviewappui.h>
#include  <avkon.hrh>
#include  "ContextContacts.hrh"
#include  <ContextContacts.rsg>
#include  "ContextContactsView.h"
#include  "ContextContactsContainer.h" 
#include <aknquerydialog.h> 
#include <RPbkViewResourceFile.h>
#include <CPbkContactEditorDlg.h>
#include <CPbkContactEngine.h>
#include <CPbkSelectFieldDlg.h>
#include <CPbkContactItem.h>
#include <cpbkfieldinfo.h> 
#include "nickform.h"
#include <eikenv.h>
#include <akniconarray.h>
#include <eikmenup.h>
#include <aknutils.h>
#include <sendnorm.rsg>
#include <senduimtmuids.h>
#include <aknnotewrappers.h> 


#include <cpbksmsaddressselect.h> 
#include <cpbkmmsaddressselect.h> 
#include <cpbkemailaddressselect.h> 
#include <cpbkphonenumberselect.h> 
#include <aknmessagequerydialog.h> 
#include "presence_ui_helper.h"

void CContextContactsView::ConstructL()
{
	CALLSTACKITEM_N(_CL("CContextContactsView"), _CL("ConstructL"));

	BaseConstructL( R_CONTEXTCONTACTS_VIEW_CONTACTS );
	iCaptionUnmark = CEikonEnv::Static()->AllocReadResourceL(R_UNMARK);
	iSendAppUi = CSendAppUi::NewL(ESendCmdId);
}

CContextContactsView::~CContextContactsView()
{
	CALLSTACKITEM_N(_CL("CContextContactsView"), _CL("~CContextContactsView"));

	RDebug::Print(_L("CContextContactsView::~CContextContactsView"));

	if ( iContainer )
        {
		AppUi()->RemoveFromViewStack( *this, iContainer );
        }
	delete iContainer;
	delete iCaptionUnmark;
	delete iSendAppUi;
}

TUid CContextContactsView::Id() const {
	return KViewId;
}

void CContextContactsView::HandleCommandL(TInt aCommand)
{   
	CALLSTACKITEM_N(_CL("CContextContactsView"), _CL("HandleCommandL"));

	
	switch ( aCommand )
        {
		case EAknSoftkeyBack:
		{
			AppUi()->HandleCommandL(EAknSoftkeyBack);
			break;
		}
		case EContextContactsCmdPresenceDetails:
		{
			iContainer->show_presence_details_current();
			break;
		}
		case EContextContactsCmdPresenceDescription:
		{
			iContainer->show_presence_description_current();
			break;
		}
		case EContextContactsCmdNew:
		{
			aPhoneHelper.show_editor(-1 /* = new*/, false /*no duplicate*/);
			break;
		}
		case EContextContactsCmdEdit:
		{
			aPhoneHelper.show_editor(aBook->GetContactId(iContainer->get_current_idx()), false);
			break;
		}
		case EContextContactsCmdDuplicate:
		{
			aPhoneHelper.show_editor(aBook->GetContactId(iContainer->get_current_idx()),  true);
			break;
		}
		case EContextContactsCmdDelete:
		{
			HBufC * header = CEikonEnv::Static()->AllocReadResourceLC(R_DELETE);
									
			if (iContainer->get_visible_selection()->Count() == 0)
			{
				// single delete:
				// warning:
				TInt contact_id = aBook->GetContactId(iContainer->get_current_idx());
				CPbkContactItem * item = aBook->get_engine()->ReadContactL(contact_id);
				CleanupStack::PushL(item);

				HBufC * message= item->GetContactTitleL();
				CleanupStack::PushL(message);
                                
				CAknMessageQueryDialog * dlg = CAknMessageQueryDialog::NewL(*message);
				CleanupStack::PushL(dlg);
				dlg->PrepareLC(R_CONFIRMATION_QUERY);
				dlg->QueryHeading()->SetTextL(*header);
				CleanupStack::Pop(dlg);
			
				if ( dlg->RunLD() )
				{
					aBook->get_engine()->DeleteContactL(contact_id);
				}
				CleanupStack::PopAndDestroy(2); //message, item
				//iContainer->set_current_idx(iContainer->get_current_idx());
			}
			else
			{
				//mass delete
				TBuf<40> message;
				message.AppendFormat(_L("%d contacts"), iContainer->get_visible_selection()->Count() );
				
				CAknMessageQueryDialog * dlg = CAknMessageQueryDialog::NewL(message);
				CleanupStack::PushL(dlg);
				dlg->PrepareLC(R_CONFIRMATION_QUERY);
				dlg->QueryHeading()->SetTextL(*header);
				CleanupStack::Pop(dlg);
			
				if ( dlg->RunLD() )
				{
					for (int i=0; i< iContainer->get_visible_selection()->Count(); i++)
					{
						TInt contact_id = aBook->GetContactId(iContainer->get_visible_selection()->At(i));
						aBook->get_engine()->DeleteContactL(contact_id);
					}
				}
				//iContainer->set_current_idx(iContainer->get_current_idx());
			}
			CleanupStack::PopAndDestroy(1); //header
			break;
		}
		case EContextContactsCmdCreateSms:
		{
			if (iContainer->get_visible_selection()->Count() == 0)
			{
				// sending sms to current item only
				CPbkPhoneNumberSelect* sel=new (ELeave) CPbkPhoneNumberSelect();
				TInt contact_id = aBook->GetContactId(iContainer->get_current_idx());
				CPbkContactItem * item = aBook->get_engine()->ReadContactL(contact_id);
				CleanupStack::PushL(item);
				TPtrC no(sel->ExecuteLD(*item, NULL, ETrue /*if there's a default number!*/));
				
				if (no!=KNullDesC)
				{
					CDesCArrayFlat* recip=new CDesCArrayFlat(1);
					CleanupStack::PushL(recip);
					CDesCArrayFlat* alias=new CDesCArrayFlat(1);
					CleanupStack::PushL(alias);
					HBufC*title = item->GetContactTitleL();
					CleanupStack::PushL(title);

					recip->AppendL(no);
					alias->AppendL(*title);
					aPhoneHelper.send_sms(recip, alias);

					CleanupStack::PopAndDestroy(3); // recip, alias, title
				}
				CleanupStack::PopAndDestroy(item);
			}
			else
			{
				// sending mass sms
				CDesCArrayFlat* recip=new CDesCArrayFlat(1);
				CleanupStack::PushL(recip);
				
				CDesCArrayFlat* alias=new CDesCArrayFlat(1);
				CleanupStack::PushL(alias);

				bool warning = false;
				HBufC * warning_note = CEikonEnv::Static()->AllocReadResourceL(R_CONTACTS_NO_SMS);
				CleanupStack::PushL(warning_note);
                                
				for (int i=0; i<iContainer->get_visible_selection()->Count();i++)
				{
					TInt contact_id = aBook->GetContactId(iContainer->get_visible_selection()->At(i));
					
					CPbkContactItem * item = aBook->get_engine()->ReadContactL(contact_id);
					CleanupStack::PushL(item);

					HBufC * title = item->GetContactTitleL();
					CleanupStack::PushL(title);

					int j=0;
					bool found = false;
                                        for (j=0; (j<item->CardFields().Count()) && (found==EFalse); j++)
					{
						 TPbkContactItemField f = (item->CardFields())[j];
						 if ( f.FieldInfo().IsPhoneNumberField() )
						 {
							found = true;
						 }
					}
					if (found)
					{
						CPbkPhoneNumberSelect* sel=new (ELeave) CPbkPhoneNumberSelect();
						TPtrC no(sel->ExecuteLD(*item, NULL, ETrue));
						if (no!=KNullDesC)
						{
							recip->AppendL(no);
							alias->AppendL(*title);
						}
						else
						{
							warning = true;
							warning_note = warning_note->ReAllocL(warning_note->Length() + title->Length() + 2);
							
							warning_note->Des().Append(_L(" "));
							warning_note->Des().Append(*title);
							warning_note->Des().Append(_L("\n"));
						}
					}
					else
					{
						warning = true;
						warning_note = warning_note->ReAllocL(warning_note->Length() + title->Length() + 2);
						warning_note->Des().Append(_L(" "));
						warning_note->Des().Append(*title);
						warning_note->Des().Append(_L("\n"));
					}
					CleanupStack::PopAndDestroy(2); //title, item
					CleanupStack::Pop(1); // old warning_note
					CleanupStack::PushL(warning_note);
				}

				if (warning)
				{
					// display warning note here
					CAknWarningNote* warning = new (ELeave) CAknWarningNote(ETrue);
					CleanupStack::PushL(warning);
					warning->ExecuteLD(*warning_note);
					CleanupStack::Pop(warning); 
				}
				CleanupStack::PopAndDestroy(); // warning_note

				if (recip->Count() > 0)
				{
					aPhoneHelper.send_sms(recip, alias);
				}
				CleanupStack::PopAndDestroy(2);// recip,  alias	

			}
			break;
		}
		case EContextContactsCmdCreateMms:
		{
			if (iContainer->get_visible_selection()->Count() == 0)
			{
				// sending mms to current item only
				CPbkMmsAddressSelect* sel=new (ELeave) CPbkMmsAddressSelect();
				TInt contact_id = aBook->GetContactId(iContainer->get_current_idx());
				CPbkContactItem * item = aBook->get_engine()->ReadContactL(contact_id);
				CleanupStack::PushL(item);
				TPtrC no(sel->ExecuteLD(*item, NULL, ETrue /*if there's a default number!*/));
				
				if (no!=KNullDesC)
				{
					CDesCArrayFlat* recip=new CDesCArrayFlat(1);
					CleanupStack::PushL(recip);
					CDesCArrayFlat* alias=new CDesCArrayFlat(1);
					CleanupStack::PushL(alias);
					HBufC*title = item->GetContactTitleL();
					CleanupStack::PushL(title);

					recip->AppendL(no);
					alias->AppendL(*title);
					aPhoneHelper.send_mms(recip,alias);

					CleanupStack::PopAndDestroy(3); // recip, alias, title
				}
				CleanupStack::PopAndDestroy(item);
			}
			else
			{
				// sending mass email

				CDesCArrayFlat* recip=new CDesCArrayFlat(1);
				CleanupStack::PushL(recip);
				
				CDesCArrayFlat* alias=new CDesCArrayFlat(1);
				CleanupStack::PushL(alias);

				bool warning = false;
				HBufC * warning_note = CEikonEnv::Static()->AllocReadResourceL(R_CONTACTS_NO_MMS);
				CleanupStack::PushL(warning_note);
                                
				for (int i=0; i<iContainer->get_visible_selection()->Count();i++)
				{
					TInt contact_id = aBook->GetContactId(iContainer->get_visible_selection()->At(i));
					
					CPbkContactItem * item = aBook->get_engine()->ReadContactL(contact_id);
					CleanupStack::PushL(item);

					HBufC * title = item->GetContactTitleL();
					CleanupStack::PushL(title);

					int j=0;
					bool found = false;
                                        for (j=0; (j<item->CardFields().Count()) && (found==EFalse); j++)
					{
						 TPbkContactItemField f = (item->CardFields())[j];
						 if ( f.FieldInfo().IsMmsField() )
						 {
							found = true;
						 }
					}
					if (found)
					{
						CPbkMmsAddressSelect* sel=new (ELeave) CPbkMmsAddressSelect();
						TPtrC no(sel->ExecuteLD(*item, NULL, ETrue));
						if (no!=KNullDesC)
						{
							recip->AppendL(no);
							alias->AppendL(*title);
						}
						else
						{
							warning = true;
							warning_note = warning_note->ReAllocL(warning_note->Length() + title->Length() + 2);
							
							warning_note->Des().Append(_L(" "));
							warning_note->Des().Append(*title);
							warning_note->Des().Append(_L("\n"));
						}
					}
					else
					{
						warning = true;
						warning_note = warning_note->ReAllocL(warning_note->Length() + title->Length() + 2);
						warning_note->Des().Append(_L(" "));
						warning_note->Des().Append(*title);
						warning_note->Des().Append(_L("\n"));
					}
					CleanupStack::PopAndDestroy(2); //title, item
					CleanupStack::Pop(1); // old warning_note
					CleanupStack::PushL(warning_note);
				}

				if (warning)
				{
					// display warning note here
					CAknWarningNote* warning = new (ELeave) CAknWarningNote(ETrue);
					CleanupStack::PushL(warning);
					warning->ExecuteLD(*warning_note);
					CleanupStack::Pop(warning); 
				}
				CleanupStack::PopAndDestroy(); // warning_note

				if (recip->Count() > 0)
				{
					aPhoneHelper.send_mms(recip, alias);
				}
				CleanupStack::PopAndDestroy(2);// recip,  alias				
			}
			break;
		}
		case EContextContactsCmdCreateEmail:
		{
			if (iContainer->get_visible_selection()->Count() == 0)
			{
				// sending e-mail to current item only
				CPbkEmailAddressSelect* sel=new (ELeave) CPbkEmailAddressSelect();
				TInt contact_id = aBook->GetContactId(iContainer->get_current_idx());
				CPbkContactItem * item = aBook->get_engine()->ReadContactL(contact_id);
				CleanupStack::PushL(item);
				TPtrC no(sel->ExecuteLD(*item, NULL, ETrue /*if there's a default number!*/));
				
				if (no!=KNullDesC)
				{
					CDesCArrayFlat* recip=new CDesCArrayFlat(1);
					CleanupStack::PushL(recip);
					CDesCArrayFlat* alias=new CDesCArrayFlat(1);
					CleanupStack::PushL(alias);
					HBufC*title = item->GetContactTitleL();
					CleanupStack::PushL(title);

					recip->AppendL(no);
					alias->AppendL(*title);
					aPhoneHelper.send_email(recip,alias);

					CleanupStack::PopAndDestroy(3); // recip, alias, title
				}
				CleanupStack::PopAndDestroy(item);
			}
			else
			{
				// sending mass email

				CDesCArrayFlat* recip=new CDesCArrayFlat(1);
				CleanupStack::PushL(recip);
				
				CDesCArrayFlat* alias=new CDesCArrayFlat(1);
				CleanupStack::PushL(alias);

				bool warning = false;
				HBufC * warning_note = CEikonEnv::Static()->AllocReadResourceL(R_CONTACTS_NO_EMAIL);
				CleanupStack::PushL(warning_note);
                                
				for (int i=0; i<iContainer->get_visible_selection()->Count();i++)
				{
					TInt contact_id = aBook->GetContactId(iContainer->get_visible_selection()->At(i));
					
					CPbkContactItem * item = aBook->get_engine()->ReadContactL(contact_id);
					CleanupStack::PushL(item);

					HBufC * title = item->GetContactTitleL();
					CleanupStack::PushL(title);

					int j=0;
					bool found = false;
                                        for (j=0; (j<item->CardFields().Count()) && (found==EFalse); j++)
					{
						 TPbkContactItemField f = (item->CardFields())[j];
						 if ( !f.FieldInfo().IsPhoneNumberField() && f.FieldInfo().IsMmsField() )
						 {
							found = true;
						 }
					}
					if (found)
					{
						CPbkEmailAddressSelect* sel=new (ELeave) CPbkEmailAddressSelect();
						TPtrC no(sel->ExecuteLD(*item, NULL, ETrue));
						if (no!=KNullDesC)
						{
							recip->AppendL(no);
							alias->AppendL(*title);
						}
						else
						{
							warning = true;
							warning_note = warning_note->ReAllocL(warning_note->Length() + title->Length() + 2);
							
							warning_note->Des().Append(_L(" "));
							warning_note->Des().Append(*title);
							warning_note->Des().Append(_L("\n"));
						}
					}
					else
					{
						warning = true;
						warning_note = warning_note->ReAllocL(warning_note->Length() + title->Length() + 2);
						warning_note->Des().Append(_L(" "));
						warning_note->Des().Append(*title);
						warning_note->Des().Append(_L("\n"));
					}
					CleanupStack::PopAndDestroy(2); //title, item
					CleanupStack::Pop(1); // old warning_note
					CleanupStack::PushL(warning_note);
				}

				if (warning)
				{
					// display warning note here
					CAknWarningNote* warning = new (ELeave) CAknWarningNote(ETrue);
					CleanupStack::PushL(warning);
					warning->ExecuteLD(*warning_note);
					CleanupStack::Pop(warning); 
				}
				CleanupStack::PopAndDestroy(); // warning_note

				if (recip->Count() > 0)
				{
					aPhoneHelper.send_email(recip, alias);
				}
				CleanupStack::PopAndDestroy(2);// recip,  alias				
			}
			break;
		}
		case EContextContactsCmdCall:
		{
			CPbkPhoneNumberSelect* sel=new (ELeave) CPbkPhoneNumberSelect();
			TInt contact_id = aBook->GetContactId(iContainer->get_current_idx());
			CPbkContactItem * item = aBook->get_engine()->ReadContactL(contact_id);
			CleanupStack::PushL(item);
			TPtrC no(sel->ExecuteLD(*item, NULL, ETrue /*if there's a default number!*/));
			CleanupStack::PopAndDestroy(item);
			aPhoneHelper.make_callL(no);
			break;
		}
		case EContextContactsCmdJabber:
		{
			set_nick();
			break;
		}		
						
		default:
		{
			if (!iSendAppUi->CommandIsValidL(aCommand, TSendingCapabilities(0, 0, TSendingCapabilities::EAllMTMs)))
			{
				AppUi()->HandleCommandL( aCommand );
			}
			else
			{
				TUid mtm = iSendAppUi->MtmForCommand(aCommand);
				CArrayFixFlat<TInt> * c = new CArrayFixFlat<TInt>(1);
				CleanupStack::PushL(c);
				if (iContainer->get_visible_selection()->Count() <= 0)
				{
					// use current item
					TInt contact_id = aBook->GetContactId(iContainer->get_current_idx());
					c->AppendL(contact_id);
				}
				else
				{
					// use marked selection
					for (int i =0; i< iContainer->get_visible_selection()->Count();i++)
					{
						TInt contact_id = aBook->GetContactId(iContainer->get_visible_selection()->At(i));
						c->AppendL(contact_id);
					}
				}
				aPhoneHelper.send_as( mtm, c);
				CleanupStack::PopAndDestroy(1); // c
			}
			break;
		}
		case EContextContactsCmdMark:
		{
			iContainer->MarkCurrentItemL();
			return;
			break;
		}
		case EContextContactsCmdUnmarkAll:
		{
			iContainer->UnmarkAll();
			return;
			break;
		}
		case EContextContactsCmdMarkAll:
		{
			iContainer->MarkAllL();
			return;
			break;
		}
	}
	iContainer->UnmarkAll();
}

void CContextContactsView::set_nick()
{
	CALLSTACKITEM_N(_CL("CContextContactsView"), _CL("set_nick"));


	TInt idx = iContainer->get_current_idx();
	TInt contact = aBook->GetContactId(idx);

	CNickForm* f=CNickForm::NewL(*aJabberData, contact, iContainer->iNameArray->MdcaPoint(idx), aBook);
	f->ExecuteLD();
}

void CContextContactsView::HandleClientRectChange()
{
	CALLSTACKITEM_N(_CL("CContextContactsView"), _CL("HandleClientRectChange"));

	
	if ( iContainer )
        {
		iContainer->SetRect( ClientRect() );
        }
}

void CContextContactsView::DoActivateL(const TVwsViewId&, TUid, const TDesC8& )
{
	CALLSTACKITEM_N(_CL("CContextContactsView"), _CL("DoActivateL"));

	mailbox_defined = aPhoneHelper.mailbox_defined();

	if (aLog) 
	{
		aLog->write_time();
		aLog->write_to_output(_L("Showing contact list"));
		aLog->write_nl();
	}

        if (!iContainer)
        {
		iContainer = create_container();
		iContainer->SetMopParent(this);
		iContainer->ConstructL( ClientRect(), aBook, aLog, aIconlist, this);
	}
	iContainer->MakeVisible(ETrue);
	iContainer->set_current_idx(current_contact_idx);
	iContainer->set_current_top_idx(current_contact_top_idx);
	AppUi()->AddToStackL( *this, iContainer );
}

void CContextContactsView::DoDeactivate()
{
	CALLSTACKITEM_N(_CL("CContextContactsView"), _CL("DoDeactivate"));

	if ( iContainer )
        {
		if (!exiting)
		{
			current_contact_idx = iContainer->get_current_idx();
			current_contact_top_idx = iContainer->get_current_top_idx();
		}
		AppUi()->RemoveFromViewStack( *this, iContainer );
		iContainer->MakeVisible(EFalse);
		delete iContainer;
		iContainer=0;
        }
}
CContextContactsContainer* CContextContactsView::create_container()
{
	CALLSTACKITEM_N(_CL("CContextContactsView"), _CL("create_container"));


	return new (ELeave) CContextContactsContainer;
}

void CContextContactsView::DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane)
{
	CALLSTACKITEM_N(_CL("CContextContactsView"), _CL("DynInitMenuPaneL"));


	if (aResourceId == R_CONTEXTCONTACTS_VIEW_CONTACTS_MENU)
	{
		if ( iContainer->CountVisibleItems() == 0 )
		{
			aMenuPane->SetItemDimmed(EContextContactsCmdOpen, ETrue);
			aMenuPane->SetItemDimmed(EContextContactsCmdCall, ETrue);
			aMenuPane->SetItemDimmed(EContextContactsCmdEdit, ETrue);
			aMenuPane->SetItemDimmed(EContextContactsCmdDelete, ETrue);
			aMenuPane->SetItemDimmed(EContextContactsCmdDuplicate, ETrue);
			aMenuPane->SetItemDimmed(EContextContactsCmdJabber, ETrue);
			//aMenuPane->SetItemDimmed(EContextContactsCmdCopyToSim, ETrue);
			aMenuPane->SetItemDimmed(EContextContactsMenuMark, ETrue);
			aMenuPane->SetItemDimmed(EContextContactsMenuMsg, ETrue);
			aMenuPane->SetItemDimmed(EContextContactsCmdPresenceDetails, ETrue);
			//aMenuPane->SetItemDimmed(EContextContactsCmdBelongsToGroup, ETrue);
			//aMenuPane->SetItemDimmed(EContextContactsCmdAddToGroup, ETrue);
		}
		else 
		{
			if (iContainer->get_visible_selection()->Count() == 0)
			{
				contact * c = aBook->GetContact(iContainer->get_current_idx());
				if (c == NULL || c->presence == NULL)
				{
					aMenuPane->SetItemDimmed(EContextContactsCmdPresenceDetails, ETrue);
				}
				else
				{
					aMenuPane->SetItemDimmed(EContextContactsCmdPresenceDetails, EFalse);
				}
				if (aJabberData == 0)
				{
					aMenuPane->SetItemDimmed(EContextContactsCmdJabber, ETrue);
				}
				else
				{
					aMenuPane->SetItemDimmed(EContextContactsCmdJabber, EFalse);
				}

				// if no group
				// don't display add to group/belongs to group

				iSendAppUi->DisplaySendMenuItemL(*aMenuPane, 11, TSendingCapabilities(0, 0, TSendingCapabilities::ESupportsAttachmentsOrBodyText  ));
			}
			else 
			{
				aMenuPane->SetItemDimmed(EContextContactsCmdOpen, ETrue);
				aMenuPane->SetItemDimmed(EContextContactsCmdCall, ETrue);
				aMenuPane->SetItemDimmed(EContextContactsCmdEdit, ETrue);
				aMenuPane->SetItemDimmed(EContextContactsCmdDuplicate, ETrue);
				aMenuPane->SetItemDimmed(EContextContactsCmdJabber, ETrue);
				aMenuPane->SetItemDimmed(EContextContactsCmdPresenceDetails, ETrue);
				aMenuPane->SetItemDimmed(EContextContactsCmdNew, ETrue);
				aMenuPane->SetItemDimmed(EContextContactsCmdInfo, ETrue);
				
				aMenuPane->SetItemDimmed(EContextContactsCmdDelete, EFalse);
				aMenuPane->SetItemDimmed(EContextContactsMenuMsg, EFalse);
				aMenuPane->SetItemDimmed(EContextContactsMenuMark, EFalse);
				
				if (iContainer->get_visible_selection()->Count() > 1)
				{
					// can't send more than one v-card with sms
					iSendAppUi->DisplaySendMenuItemL(*aMenuPane, 11, TSendingCapabilities(0, 0, TSendingCapabilities::ESupportsAttachments));
				}
				else
				{
					iSendAppUi->DisplaySendMenuItemL(*aMenuPane, 11, TSendingCapabilities(0, 0, TSendingCapabilities::ESupportsAttachmentsOrBodyText ));
				}
			}
		}
	}
	else if (aResourceId == R_MESSAGE_MENU)
	{
		if (mailbox_defined)
		{
			aMenuPane->SetItemDimmed(EContextContactsCmdCreateEmail, EFalse);
		}
		else
		{
			aMenuPane->SetItemDimmed(EContextContactsCmdCreateEmail, ETrue);
		}
	}
	else if (aResourceId == R_MARK_MENU)
	{
		if (iContainer->IsCurrentMarked() )
		{
			aMenuPane->SetItemTextL(EContextContactsCmdMark, iCaptionUnmark->Des());
		}
		if ( iContainer->get_visible_selection()->Count()== 0 )
		{
			aMenuPane->SetItemDimmed(EContextContactsCmdUnmarkAll, ETrue);
		}
		if ( iContainer->CountVisibleItems() == iContainer->get_visible_selection()->Count() )
		{
			aMenuPane->SetItemDimmed(EContextContactsCmdMarkAll, ETrue);
		}
	}
	else if (aResourceId == R_SENDUI_MENU)
	{
		iSendAppUi->DisplaySendCascadeMenuL(*aMenuPane);
	}
}

TInt CContextContactsView::GetCurrentContactId()
{
	CALLSTACKITEM_N(_CL("CContextContactsView"), _CL("GetCurrentContactId"));

	return aBook->GetContactId(iContainer->get_current_idx());
}

void CContextContactsView::before_exit()
{
	exiting = true;
}


